/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.ipa;

import java.util.Map;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.ipa.FunctionCallGraph;
import org.apache.sysds.hops.ipa.FunctionCallSizeInfo;
import org.apache.sysds.hops.ipa.IPAPass;
import org.apache.sysds.hops.ipa.InterProceduralAnalysis;
import org.apache.sysds.lops.Compression;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.runtime.compress.workload.WTreeNode;
import org.apache.sysds.runtime.compress.workload.WorkloadAnalyzer;

public class IPAPassCompressionWorkloadAnalysis
extends IPAPass {
    @Override
    public boolean isApplicable(FunctionCallGraph fgraph) {
        return InterProceduralAnalysis.CLA_WORKLOAD_ANALYSIS && Compression.CompressConfig.valueOf(ConfigurationManager.getDMLConfig().getTextValue("sysds.compressed.linalg").toUpperCase()).isEnabled();
    }

    @Override
    public boolean rewriteProgram(DMLProgram prog, FunctionCallGraph fgraph, FunctionCallSizeInfo fcallSizes) {
        Map<Long, WTreeNode> map = WorkloadAnalyzer.getAllCandidateWorkloads(prog);
        for (Map.Entry<Long, WTreeNode> e : map.entrySet()) {
            System.out.println(e.getValue());
        }
        return map != null;
    }
}

