/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CachePoolIterator
extends BatchedRemoteIterator<String, CachePoolEntry> {
    private final ClientProtocol namenode;

    public CachePoolIterator(ClientProtocol namenode) {
        super((Object)"");
        this.namenode = namenode;
    }

    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> makeRequest(String prevKey) throws IOException {
        return this.namenode.listCachePools(prevKey);
    }

    public String elementToPrevKey(CachePoolEntry entry) {
        return entry.getInfo().getPoolName();
    }
}

