/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.codegen.SpoofOperator;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.UtilFunctions;

public abstract class SpoofOuterProduct
extends SpoofOperator {
    private static final long serialVersionUID = 2948612259863710279L;
    private static final int L2_CACHESIZE = 262144;
    protected OutProdType _outerProductType;

    public SpoofOuterProduct(OutProdType type) {
        this.setOuterProdType(type);
    }

    public void setOuterProdType(OutProdType type) {
        this._outerProductType = type;
    }

    public OutProdType getOuterProdType() {
        return this._outerProductType;
    }

    @Override
    public String getSpoofType() {
        return "OP" + this.getClass().getName().split("\\.")[1];
    }

    @Override
    public ScalarObject execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects) {
        if (inputs == null || inputs.size() < 3) {
            throw new RuntimeException("Invalid input arguments.");
        }
        if (inputs.get(0).isEmptyBlock(false)) {
            return new DoubleObject(0.0);
        }
        DenseBlock[] ab = SpoofOuterProduct.getDenseMatrices(this.prepInputMatrices(inputs, 1, 2, true, false));
        SpoofOperator.SideInput[] b = this.prepInputMatrices(inputs, 3, false);
        double[] scalars = SpoofOuterProduct.prepInputScalars(scalarObjects);
        int m = inputs.get(0).getNumRows();
        int n = inputs.get(0).getNumColumns();
        int k = inputs.get(1).getNumColumns();
        MatrixBlock a = inputs.get(0);
        MatrixBlock out = new MatrixBlock(1, 1, false);
        out.allocateDenseBlock();
        if (!a.isInSparseFormat()) {
            this.executeCellwiseDense(a.getDenseBlock(), ab[0], ab[1], b, scalars, out.getDenseBlock(), m, n, k, this._outerProductType, 0, m, 0, n);
        } else {
            this.executeCellwiseSparse(a.getSparseBlock(), ab[0], ab[1], b, scalars, out, m, n, k, a.getNonZeros(), this._outerProductType, 0, m, 0, n);
        }
        return new DoubleObject(out.getDenseBlock().get(0, 0));
    }

    @Override
    public ScalarObject execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, int numThreads) {
        if (inputs == null || inputs.size() < 3) {
            throw new RuntimeException("Invalid input arguments.");
        }
        if (inputs.get(0).isEmptyBlock(false)) {
            return new DoubleObject(0.0);
        }
        if (2L * inputs.get(0).getNonZeros() * (long)inputs.get(1).getNumColumns() < 0x200000L) {
            return this.execute(inputs, scalarObjects);
        }
        DenseBlock[] ab = SpoofOuterProduct.getDenseMatrices(this.prepInputMatrices(inputs, 1, 2, true, false));
        SpoofOperator.SideInput[] b = this.prepInputMatrices(inputs, 3, false);
        double[] scalars = SpoofOuterProduct.prepInputScalars(scalarObjects);
        int m = inputs.get(0).getNumRows();
        int n = inputs.get(0).getNumColumns();
        int k = inputs.get(1).getNumColumns();
        long nnz = inputs.get(0).getNonZeros();
        double sum = 0.0;
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<ParOuterProdAggTask> tasks = new ArrayList<ParOuterProdAggTask>();
            int numThreads2 = SpoofOuterProduct.getPreferredNumberOfTasks(m, n, nnz, k, numThreads);
            int blklen = (int)Math.ceil((double)m / (double)numThreads2);
            int i = 0;
            while (i < numThreads2 & i * blklen < m) {
                tasks.add(new ParOuterProdAggTask(inputs.get(0), ab[0], ab[1], b, scalars, m, n, k, this._outerProductType, i * blklen, Math.min((i + 1) * blklen, m), 0, n));
                ++i;
            }
            List taskret = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future task : taskret) {
                sum += ((Double)task.get()).doubleValue();
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
        return new DoubleObject(sum);
    }

    @Override
    public MatrixBlock execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, MatrixBlock out) {
        if (inputs == null || inputs.size() < 3 || out == null) {
            throw new RuntimeException("Invalid input arguments.");
        }
        if (this._outerProductType == OutProdType.LEFT_OUTER_PRODUCT && inputs.get(1).isEmptyBlock(false) || this._outerProductType == OutProdType.RIGHT_OUTER_PRODUCT && inputs.get(2).isEmptyBlock(false) || inputs.get(0).isEmptyBlock(false)) {
            out.examSparsity();
            return out;
        }
        if (this._outerProductType == OutProdType.CELLWISE_OUTER_PRODUCT) {
            out.reset(inputs.get(0).getNumRows(), inputs.get(0).getNumColumns(), inputs.get(0).isInSparseFormat());
        } else if (this._outerProductType == OutProdType.LEFT_OUTER_PRODUCT) {
            out.reset(inputs.get(0).getNumColumns(), inputs.get(1).getNumColumns(), false);
        } else if (this._outerProductType == OutProdType.RIGHT_OUTER_PRODUCT) {
            out.reset(inputs.get(0).getNumRows(), inputs.get(1).getNumColumns(), false);
        }
        if (inputs.get(0).isEmptyBlock(false)) {
            return out;
        }
        out.allocateBlock();
        DenseBlock[] ab = SpoofOuterProduct.getDenseMatrices(this.prepInputMatrices(inputs, 1, 2, true, false));
        SpoofOperator.SideInput[] b = this.prepInputMatrices(inputs, 3, false);
        double[] scalars = SpoofOuterProduct.prepInputScalars(scalarObjects);
        int m = inputs.get(0).getNumRows();
        int n = inputs.get(0).getNumColumns();
        int k = inputs.get(1).getNumColumns();
        MatrixBlock a = inputs.get(0);
        switch (this._outerProductType) {
            case LEFT_OUTER_PRODUCT: 
            case RIGHT_OUTER_PRODUCT: {
                if (!a.isInSparseFormat()) {
                    this.executeDense(a.getDenseBlock(), ab[0], ab[1], b, scalars, out.getDenseBlock(), m, n, k, this._outerProductType, 0, m, 0, n);
                    break;
                }
                this.executeSparse(a.getSparseBlock(), ab[0], ab[1], b, scalars, out.getDenseBlock(), m, n, k, a.getNonZeros(), this._outerProductType, 0, m, 0, n);
                break;
            }
            case CELLWISE_OUTER_PRODUCT: {
                if (!a.isInSparseFormat()) {
                    this.executeCellwiseDense(a.getDenseBlock(), ab[0], ab[1], b, scalars, out.getDenseBlock(), m, n, k, this._outerProductType, 0, m, 0, n);
                    break;
                }
                this.executeCellwiseSparse(a.getSparseBlock(), ab[0], ab[1], b, scalars, out, m, n, k, a.getNonZeros(), this._outerProductType, 0, m, 0, n);
                break;
            }
            case AGG_OUTER_PRODUCT: {
                throw new DMLRuntimeException("Wrong codepath for aggregate outer product.");
            }
        }
        out.recomputeNonZeros();
        out.examSparsity();
        return out;
    }

    @Override
    public MatrixBlock execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, MatrixBlock out, int numThreads) {
        if (inputs == null || inputs.size() < 3 || out == null) {
            throw new RuntimeException("Invalid input arguments.");
        }
        if (this._outerProductType == OutProdType.LEFT_OUTER_PRODUCT && inputs.get(1).isEmptyBlock(false) || this._outerProductType == OutProdType.RIGHT_OUTER_PRODUCT && inputs.get(2).isEmptyBlock(false) || inputs.get(0).isEmptyBlock(false)) {
            out.examSparsity();
            return out;
        }
        if (this._outerProductType == OutProdType.CELLWISE_OUTER_PRODUCT) {
            out.reset(inputs.get(0).getNumRows(), inputs.get(0).getNumColumns(), inputs.get(0).isInSparseFormat());
            out.allocateBlock();
        } else {
            if (this._outerProductType == OutProdType.LEFT_OUTER_PRODUCT) {
                out.reset(inputs.get(0).getNumColumns(), inputs.get(1).getNumColumns(), false);
            } else if (this._outerProductType == OutProdType.RIGHT_OUTER_PRODUCT) {
                out.reset(inputs.get(0).getNumRows(), inputs.get(1).getNumColumns(), false);
            }
            out.allocateDenseBlock();
        }
        if (2L * inputs.get(0).getNonZeros() * (long)inputs.get(1).getNumColumns() < 0x200000L) {
            return this.execute(inputs, scalarObjects, out);
        }
        DenseBlock[] ab = SpoofOuterProduct.getDenseMatrices(this.prepInputMatrices(inputs, 1, 2, true, false));
        SpoofOperator.SideInput[] b = this.prepInputMatrices(inputs, 3, false);
        double[] scalars = SpoofOuterProduct.prepInputScalars(scalarObjects);
        int m = inputs.get(0).getNumRows();
        int n = inputs.get(0).getNumColumns();
        int k = inputs.get(1).getNumColumns();
        long nnz = inputs.get(0).getNonZeros();
        MatrixBlock a = inputs.get(0);
        try {
            ExecutorService pool = CommonThreadPool.get(numThreads);
            ArrayList<ParExecTask> tasks = new ArrayList<ParExecTask>();
            if (this._outerProductType == OutProdType.LEFT_OUTER_PRODUCT) {
                int blklen = (int)Math.ceil((double)n / (double)numThreads);
                int j = 0;
                while (j < numThreads & j * blklen < n) {
                    tasks.add(new ParExecTask(a, ab[0], ab[1], b, scalars, out, m, n, k, this._outerProductType, 0, m, j * blklen, Math.min((j + 1) * blklen, n)));
                    ++j;
                }
            } else {
                int numThreads2 = SpoofOuterProduct.getPreferredNumberOfTasks(m, n, nnz, k, numThreads);
                int blklen = (int)Math.ceil((double)m / (double)numThreads2);
                int i = 0;
                while (i < numThreads2 & i * blklen < m) {
                    tasks.add(new ParExecTask(a, ab[0], ab[1], b, scalars, out, m, n, k, this._outerProductType, i * blklen, Math.min((i + 1) * blklen, m), 0, n));
                    ++i;
                }
            }
            List taskret = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future task : taskret) {
                out.setNonZeros(out.getNonZeros() + (Long)task.get());
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
        out.examSparsity();
        return out;
    }

    private static int getPreferredNumberOfTasks(int m, int n, long nnz, int rank, int k) {
        int base = (int)Math.min((double)Math.min(8 * k, m / 32), Math.ceil(2.0 * (double)nnz * (double)rank / 2097152.0));
        return UtilFunctions.roundToNext(base, k);
    }

    private void executeDense(DenseBlock a, DenseBlock u, DenseBlock v, SpoofOperator.SideInput[] b, double[] scalars, DenseBlock c, int m, int n, int k, OutProdType type, int rl, int ru, int cl, int cu) {
        int blocksizeIJ = 16;
        int cix = 0;
        for (int bi = rl; bi < ru; bi += 16) {
            int bimin = Math.min(ru, bi + 16);
            for (int bj = cl; bj < cu; bj += 16) {
                int bjmin = Math.min(cu, bj + 16);
                for (int i = bi; i < bimin; ++i) {
                    double[] avals = a.values(i);
                    double[] uvals = u.values(i);
                    int aix = a.pos(i);
                    int uix = u.pos(i);
                    for (int j = bj; j < bjmin; ++j) {
                        if (avals[aix + j] == 0.0) continue;
                        int vix = v.pos(j);
                        cix = type == OutProdType.LEFT_OUTER_PRODUCT ? vix : uix;
                        this.genexecDense(avals[aix + j], uvals, uix, v.values(j), vix, b, scalars, c.values(j), cix, m, n, k, i, j);
                    }
                }
            }
        }
    }

    private void executeCellwiseDense(DenseBlock a, DenseBlock u, DenseBlock v, SpoofOperator.SideInput[] b, double[] scalars, DenseBlock c, int m, int n, int k, OutProdType type, int rl, int ru, int cl, int cu) {
        int blocksizeIJ = 16;
        double sum = 0.0;
        for (int bi = rl; bi < ru; bi += 16) {
            int bimin = Math.min(ru, bi + 16);
            for (int bj = cl; bj < cu; bj += 16) {
                int bjmin = Math.min(cu, bj + 16);
                for (int i = bi; i < bimin; ++i) {
                    double[] avals = a.values(i);
                    double[] uvals = u.values(i);
                    int aix = a.pos(i);
                    int uix = u.pos(i);
                    if (type == OutProdType.CELLWISE_OUTER_PRODUCT) {
                        double[] cvals = c.values(i);
                        for (int j = bj; j < bjmin; ++j) {
                            if (avals[aix + j] == 0.0) continue;
                            cvals[aix + j] = this.genexecCellwise(avals[aix + j], uvals, uix, v.values(j), v.pos(j), b, scalars, m, n, k, i, j);
                        }
                        continue;
                    }
                    for (int j = bj; j < bjmin; ++j) {
                        if (avals[aix + j] == 0.0) continue;
                        sum += this.genexecCellwise(avals[aix + j], uvals, uix, v.values(j), v.pos(j), b, scalars, m, n, k, i, j);
                    }
                }
            }
        }
        if (type != OutProdType.CELLWISE_OUTER_PRODUCT) {
            c.set(0, 0, sum);
        }
    }

    private void executeSparse(SparseBlock sblock, DenseBlock u, DenseBlock v, SpoofOperator.SideInput[] b, double[] scalars, DenseBlock c, int m, int n, int k, long nnz, OutProdType type, int rl, int ru, int cl, int cu) {
        boolean left = this._outerProductType == OutProdType.LEFT_OUTER_PRODUCT;
        int blocksizeI = (int)(8L * (long)m * (long)n / nnz);
        if (OptimizerUtils.getSparsity(m, n, nnz) < 4.0E-5) {
            SpoofOperator.SideInput[] lb = SpoofOuterProduct.createSparseSideInputs(b);
            for (int i = rl; i < ru; ++i) {
                if (sblock.isEmpty(i)) continue;
                int wpos = sblock.pos(i);
                int wlen = sblock.size(i);
                int[] wix = sblock.indexes(i);
                double[] wvals = sblock.values(i);
                double[] uvals = u.values(i);
                int uix = u.pos(i);
                int index = cl == 0 || sblock.isEmpty(i) ? 0 : sblock.posFIndexGTE(i, cl);
                for (index = wpos + (index >= 0 ? index : n); index < wpos + wlen && wix[index] < cu; ++index) {
                    int jix = wix[index];
                    this.genexecDense(wvals[index], uvals, uix, v.values(jix), v.pos(jix), lb, scalars, c.values(jix), left ? v.pos(jix) : uix, m, n, k, i, wix[index]);
                }
            }
        } else {
            int blocksizeJ = left ? Math.max(8, Math.min(262144 / (k * 8), blocksizeI)) : blocksizeI;
            int[] curk = new int[Math.min(blocksizeI, ru - rl)];
            for (int bi = rl; bi < ru; bi += blocksizeI) {
                int bimin = Math.min(ru, bi + blocksizeI);
                for (int i = bi; i < bimin; ++i) {
                    int index = cl == 0 || sblock.isEmpty(i) ? 0 : sblock.posFIndexGTE(i, cl);
                    curk[i - bi] = index >= 0 ? index : n;
                }
                for (int bj = cl; bj < cu; bj += blocksizeJ) {
                    int bjmin = Math.min(cu, bj + blocksizeJ);
                    for (int i = bi; i < bimin; ++i) {
                        int index;
                        if (sblock.isEmpty(i)) continue;
                        int wpos = sblock.pos(i);
                        int wlen = sblock.size(i);
                        int[] wix = sblock.indexes(i);
                        double[] wvals = sblock.values(i);
                        double[] uvals = u.values(i);
                        int uix = u.pos(i);
                        for (index = wpos + curk[i - bi]; index < wpos + wlen && wix[index] < bjmin; ++index) {
                            int jix = wix[index];
                            this.genexecDense(wvals[index], uvals, uix, v.values(jix), v.pos(jix), b, scalars, c.values(jix), left ? wix[index] * k : uix, m, n, k, i, wix[index]);
                        }
                        curk[i - bi] = index - wpos;
                    }
                }
            }
        }
    }

    private void executeCellwiseSparse(SparseBlock sblock, DenseBlock u, DenseBlock v, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, int k, long nnz, OutProdType type, int rl, int ru, int cl, int cu) {
        int blocksizeIJ = (int)(8L * (long)m * (long)n / nnz);
        int[] curk = new int[Math.min(blocksizeIJ, ru - rl)];
        if (!out.isInSparseFormat()) {
            DenseBlock c = out.getDenseBlock();
            double tmp = 0.0;
            for (int bi = rl; bi < ru; bi += blocksizeIJ) {
                int bimin = Math.min(ru, bi + blocksizeIJ);
                Arrays.fill(curk, 0);
                for (int bj = 0; bj < n; bj += blocksizeIJ) {
                    int bjmin = Math.min(n, bj + blocksizeIJ);
                    for (int i = bi; i < bimin; ++i) {
                        int jix;
                        int index;
                        if (sblock.isEmpty(i)) continue;
                        int wpos = sblock.pos(i);
                        int wlen = sblock.size(i);
                        int[] wix = sblock.indexes(i);
                        double[] wvals = sblock.values(i);
                        double[] cvals = c.values(i);
                        double[] uvals = u.values(i);
                        int uix = u.pos(i);
                        if (type == OutProdType.CELLWISE_OUTER_PRODUCT) {
                            for (index = wpos + curk[i - bi]; index < wpos + wlen && wix[index] < bjmin; ++index) {
                                jix = wix[index];
                                cvals[jix] = this.genexecCellwise(wvals[index], uvals, uix, v.values(jix), v.pos(jix), b, scalars, m, n, k, i, wix[index]);
                            }
                        } else {
                            while (index < wpos + wlen && wix[index] < bjmin) {
                                jix = wix[index];
                                tmp += this.genexecCellwise(wvals[index], uvals, uix, v.values(jix), v.pos(jix), b, scalars, m, n, k, i, wix[index]);
                                ++index;
                            }
                        }
                        curk[i - bi] = index - wpos;
                    }
                }
            }
            if (type != OutProdType.CELLWISE_OUTER_PRODUCT) {
                c.set(0, 0, tmp);
            }
        } else {
            SparseBlock c = out.getSparseBlock();
            for (int bi = rl; bi < ru; bi += blocksizeIJ) {
                int bimin = Math.min(ru, bi + blocksizeIJ);
                Arrays.fill(curk, 0);
                for (int bj = 0; bj < n; bj += blocksizeIJ) {
                    int bjmin = Math.min(n, bj + blocksizeIJ);
                    for (int i = bi; i < bimin; ++i) {
                        int index;
                        if (sblock.isEmpty(i)) continue;
                        int wpos = sblock.pos(i);
                        int wlen = sblock.size(i);
                        int[] wix = sblock.indexes(i);
                        double[] wval = sblock.values(i);
                        double[] uvals = u.values(i);
                        int uix = u.pos(i);
                        for (index = wpos + curk[i - bi]; index < wpos + wlen && wix[index] < bjmin; ++index) {
                            int jix = wix[index];
                            c.append(i, wix[index], this.genexecCellwise(wval[index], uvals, uix, v.values(jix), v.pos(jix), b, scalars, m, n, k, i, wix[index]));
                        }
                        curk[i - bi] = index - wpos;
                    }
                }
            }
        }
    }

    protected abstract void genexecDense(double var1, double[] var3, int var4, double[] var5, int var6, SpoofOperator.SideInput[] var7, double[] var8, double[] var9, int var10, int var11, int var12, int var13, int var14, int var15);

    protected abstract double genexecCellwise(double var1, double[] var3, int var4, double[] var5, int var6, SpoofOperator.SideInput[] var7, double[] var8, int var9, int var10, int var11, int var12, int var13);

    private class ParOuterProdAggTask
    implements Callable<Double> {
        private final MatrixBlock _a;
        private final DenseBlock _u;
        private final DenseBlock _v;
        private final SpoofOperator.SideInput[] _b;
        private final double[] _scalars;
        private final int _rlen;
        private final int _clen;
        private final int _k;
        private final OutProdType _type;
        private final int _rl;
        private final int _ru;
        private final int _cl;
        private final int _cu;

        protected ParOuterProdAggTask(MatrixBlock a, DenseBlock u, DenseBlock v, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, int k, OutProdType type, int rl, int ru, int cl, int cu) {
            this._a = a;
            this._u = u;
            this._v = v;
            this._b = b;
            this._scalars = scalars;
            this._rlen = m;
            this._clen = n;
            this._k = k;
            this._type = type;
            this._rl = rl;
            this._ru = ru;
            this._cl = cl;
            this._cu = cu;
        }

        @Override
        public Double call() {
            MatrixBlock out = new MatrixBlock(1, 1, false);
            out.allocateDenseBlock();
            if (!this._a.isInSparseFormat()) {
                SpoofOuterProduct.this.executeCellwiseDense(this._a.getDenseBlock(), this._u, this._v, this._b, this._scalars, out.getDenseBlock(), this._rlen, this._clen, this._k, this._type, this._rl, this._ru, this._cl, this._cu);
            } else {
                SpoofOuterProduct.this.executeCellwiseSparse(this._a.getSparseBlock(), this._u, this._v, this._b, this._scalars, out, this._rlen, this._clen, this._k, this._a.getNonZeros(), this._type, this._rl, this._ru, this._cl, this._cu);
            }
            return out.quickGetValue(0, 0);
        }
    }

    private class ParExecTask
    implements Callable<Long> {
        private final MatrixBlock _a;
        private final DenseBlock _u;
        private final DenseBlock _v;
        private final SpoofOperator.SideInput[] _b;
        private final double[] _scalars;
        private final MatrixBlock _c;
        private final int _clen;
        private final int _rlen;
        private final int _k;
        private final OutProdType _type;
        private final int _rl;
        private final int _ru;
        private final int _cl;
        private final int _cu;

        protected ParExecTask(MatrixBlock a, DenseBlock u, DenseBlock v, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock c, int m, int n, int k, OutProdType type, int rl, int ru, int cl, int cu) {
            this._a = a;
            this._u = u;
            this._v = v;
            this._b = b;
            this._c = c;
            this._scalars = scalars;
            this._rlen = m;
            this._clen = n;
            this._k = k;
            this._type = type;
            this._rl = rl;
            this._ru = ru;
            this._cl = cl;
            this._cu = cu;
        }

        @Override
        public Long call() {
            switch (this._type) {
                case LEFT_OUTER_PRODUCT: 
                case RIGHT_OUTER_PRODUCT: {
                    if (!this._a.isInSparseFormat()) {
                        SpoofOuterProduct.this.executeDense(this._a.getDenseBlock(), this._u, this._v, this._b, this._scalars, this._c.getDenseBlock(), this._rlen, this._clen, this._k, this._type, this._rl, this._ru, this._cl, this._cu);
                        break;
                    }
                    SpoofOuterProduct.this.executeSparse(this._a.getSparseBlock(), this._u, this._v, this._b, this._scalars, this._c.getDenseBlock(), this._rlen, this._clen, this._k, this._a.getNonZeros(), this._type, this._rl, this._ru, this._cl, this._cu);
                    break;
                }
                case CELLWISE_OUTER_PRODUCT: {
                    if (!this._c.isInSparseFormat()) {
                        SpoofOuterProduct.this.executeCellwiseDense(this._a.getDenseBlock(), this._u, this._v, this._b, this._scalars, this._c.getDenseBlock(), this._rlen, this._clen, this._k, this._type, this._rl, this._ru, this._cl, this._cu);
                        break;
                    }
                    SpoofOuterProduct.this.executeCellwiseSparse(this._a.getSparseBlock(), this._u, this._v, this._b, this._scalars, this._c, this._rlen, this._clen, this._k, this._a.getNonZeros(), this._type, this._rl, this._ru, this._cl, this._cu);
                    break;
                }
                case AGG_OUTER_PRODUCT: {
                    throw new DMLRuntimeException("Wrong codepath for aggregate outer product.");
                }
            }
            boolean left = SpoofOuterProduct.this._outerProductType == OutProdType.LEFT_OUTER_PRODUCT;
            int rl = left ? this._cl : this._rl;
            int ru = left ? this._cu : this._ru;
            return this._c.recomputeNonZeros(rl, ru - 1, 0, this._c.getNumColumns() - 1);
        }
    }

    public static enum OutProdType {
        LEFT_OUTER_PRODUCT,
        RIGHT_OUTER_PRODUCT,
        CELLWISE_OUTER_PRODUCT,
        AGG_OUTER_PRODUCT;

    }
}

