/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.util.Arrays;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.TfUtils;
import org.apache.sysds.runtime.transform.encode.Encoder;
import org.apache.sysds.runtime.transform.meta.TfMetaUtils;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class EncoderOmit
extends Encoder {
    private static final long serialVersionUID = 1978852120416654195L;
    private boolean _federated = false;
    private boolean[] _rmRows = new boolean[0];

    public EncoderOmit(JSONObject parsedSpec, String[] colnames, int clen, int minCol, int maxCol) throws JSONException {
        super(null, clen);
        if (!parsedSpec.containsKey(TfUtils.TfMethod.OMIT.toString())) {
            return;
        }
        int[] collist = TfMetaUtils.parseJsonIDList(parsedSpec, colnames, TfUtils.TfMethod.OMIT.toString(), minCol, maxCol);
        this.initColList(collist);
        this._federated = minCol != -1 || maxCol != -1;
    }

    public EncoderOmit() {
        super(new int[0], 0);
    }

    public EncoderOmit(boolean federated) {
        this();
        this._federated = federated;
    }

    private EncoderOmit(int[] colList, int clen, boolean[] rmRows) {
        super(colList, clen);
        this._rmRows = rmRows;
        this._federated = true;
    }

    public int getNumRemovedRows(boolean[] rmRows) {
        int cnt = 0;
        for (boolean v : rmRows) {
            cnt += v ? 1 : 0;
        }
        return cnt;
    }

    public int getNumRemovedRows() {
        return this.getNumRemovedRows(this._rmRows);
    }

    public boolean omit(String[] words, TfUtils agents) {
        if (!this.isApplicable()) {
            return false;
        }
        for (int i = 0; i < this._colList.length; ++i) {
            int colID = this._colList[i];
            if (!TfUtils.isNA(agents.getNAStrings(), UtilFunctions.unquote(words[colID - 1].trim()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
        if (this._federated) {
            this._rmRows = this.computeRmRows(in);
        }
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        boolean[] rmRows = this._federated ? this._rmRows : this.computeRmRows(in);
        int numRows = out.getNumRows() - this.getNumRemovedRows(rmRows);
        MatrixBlock ret = new MatrixBlock(numRows, out.getNumColumns(), false);
        int pos = 0;
        for (int i = 0; i < in.getNumRows(); ++i) {
            if (rmRows[i]) continue;
            for (int j = 0; j < out.getNumColumns(); ++j) {
                ret.quickSetValue(pos, j, out.quickGetValue(i, j));
            }
            ++pos;
        }
        this._rmRows = rmRows;
        return ret;
    }

    private boolean[] computeRmRows(FrameBlock in) {
        boolean[] rmRows = new boolean[in.getNumRows()];
        Types.ValueType[] schema = in.getSchema();
        block0: for (int i = 0; i < in.getNumRows(); ++i) {
            for (int colID : this._colList) {
                Object val = in.get(i, colID - 1);
                if (val != null && (schema[colID - 1] != Types.ValueType.STRING || !val.toString().isEmpty())) continue;
                rmRows[i] = true;
                continue block0;
            }
        }
        return rmRows;
    }

    @Override
    public Encoder subRangeEncoder(IndexRange ixRange) {
        int[] colList = this.subRangeColList(ixRange);
        if (colList.length == 0) {
            return null;
        }
        boolean[] rmRows = this._rmRows;
        if (this._rmRows.length > 0) {
            rmRows = Arrays.copyOfRange(rmRows, (int)ixRange.rowStart - 1, (int)ixRange.rowEnd - 1);
        }
        return new EncoderOmit(colList, (int)ixRange.colSpan(), rmRows);
    }

    @Override
    public void mergeAt(Encoder other, int row, int col) {
        if (other instanceof EncoderOmit) {
            this.mergeColumnInfo(other, col);
            EncoderOmit otherOmit = (EncoderOmit)other;
            this._rmRows = Arrays.copyOf(this._rmRows, Math.max(this._rmRows.length, row - 1 + otherOmit._rmRows.length));
            for (int i = 0; i < otherOmit._rmRows.length; ++i) {
                int n = row - 1 + 1;
                this._rmRows[n] = this._rmRows[n] | otherOmit._rmRows[i];
            }
            return;
        }
        super.mergeAt(other, row, col);
    }

    @Override
    public void updateIndexRanges(long[] beginDims, long[] endDims) {
        int i;
        int numRowsToRemove = 0;
        for (i = 0; (long)i < beginDims[0] - 1L && i < this._rmRows.length; ++i) {
            if (!this._rmRows[i]) continue;
            ++numRowsToRemove;
        }
        beginDims[0] = beginDims[0] - (long)numRowsToRemove;
        for (i = 0; (long)i < endDims[0] - 1L && i < this._rmRows.length; ++i) {
            if (!this._rmRows[i]) continue;
            ++numRowsToRemove;
        }
        endDims[0] = endDims[0] - (long)numRowsToRemove;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock out) {
        return out;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
    }
}

