/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark.functions;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.util.UtilFunctions;
import scala.Tuple2;

public class ExtractBlockForBinaryReblock
implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
    private static final long serialVersionUID = -762987655085029215L;
    private final long rlen;
    private final long clen;
    private final int in_brlen;
    private final int in_bclen;
    private final int out_brlen;
    private final int out_bclen;

    public ExtractBlockForBinaryReblock(MatrixCharacteristics mcIn, MatrixCharacteristics mcOut) {
        this.rlen = mcIn.getRows();
        this.clen = mcIn.getCols();
        this.in_brlen = mcIn.getRowsPerBlock();
        this.in_bclen = mcIn.getColsPerBlock();
        this.out_brlen = mcOut.getRowsPerBlock();
        this.out_bclen = mcOut.getColsPerBlock();
        if (this.in_brlen <= 0 || this.in_bclen <= 0 || this.out_brlen <= 0 || this.out_bclen <= 0) {
            throw new DMLRuntimeException("Block sizes not unknown:" + this.in_brlen + "," + this.in_bclen + "," + this.out_brlen + "," + this.out_bclen);
        }
    }

    public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
        MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
        MatrixBlock in = (MatrixBlock)arg0._2();
        long startRowGlobalCellIndex = UtilFunctions.computeCellIndex(ixIn.getRowIndex(), this.in_brlen, 0);
        long endRowGlobalCellIndex = this.getEndGlobalIndex(ixIn.getRowIndex(), true, true);
        long startColGlobalCellIndex = UtilFunctions.computeCellIndex(ixIn.getColumnIndex(), this.in_bclen, 0);
        long endColGlobalCellIndex = this.getEndGlobalIndex(ixIn.getColumnIndex(), true, false);
        long out_startRowBlockIndex = UtilFunctions.computeBlockIndex(startRowGlobalCellIndex, this.out_brlen);
        long out_endRowBlockIndex = UtilFunctions.computeBlockIndex(endRowGlobalCellIndex, this.out_brlen);
        long out_startColBlockIndex = UtilFunctions.computeBlockIndex(startColGlobalCellIndex, this.out_bclen);
        long out_endColBlockIndex = UtilFunctions.computeBlockIndex(endColGlobalCellIndex, this.out_bclen);
        boolean aligned = this.out_brlen % this.in_brlen == 0 && this.out_bclen % this.in_bclen == 0;
        ArrayList<Tuple2> retVal = new ArrayList<Tuple2>();
        for (long i = out_startRowBlockIndex; i <= out_endRowBlockIndex; ++i) {
            for (long j = out_startColBlockIndex; j <= out_endColBlockIndex; ++j) {
                MatrixIndexes indx = new MatrixIndexes(i, j);
                int new_lrlen = UtilFunctions.computeBlockSize(this.rlen, i, this.out_brlen);
                int new_lclen = UtilFunctions.computeBlockSize(this.clen, j, this.out_bclen);
                MatrixBlock blk = new MatrixBlock(new_lrlen, new_lclen, true);
                if (in.isEmptyBlock(false)) continue;
                long rowLower = Math.max(UtilFunctions.computeCellIndex(i, this.out_brlen, 0), startRowGlobalCellIndex);
                long rowUpper = Math.min(this.getEndGlobalIndex(i, false, true), endRowGlobalCellIndex);
                long colLower = Math.max(UtilFunctions.computeCellIndex(j, this.out_bclen, 0), startColGlobalCellIndex);
                long colUpper = Math.min(this.getEndGlobalIndex(j, false, false), endColGlobalCellIndex);
                int aixi = UtilFunctions.computeCellInBlock(rowLower, this.in_brlen);
                int aixj = UtilFunctions.computeCellInBlock(colLower, this.in_bclen);
                int cixi = UtilFunctions.computeCellInBlock(rowLower, this.out_brlen);
                int cixj = UtilFunctions.computeCellInBlock(colLower, this.out_bclen);
                if (aligned) {
                    blk.appendToSparse(in, cixi, cixj);
                    blk.setNonZeros(in.getNonZeros());
                } else {
                    for (int i2 = 0; i2 <= (int)(rowUpper - rowLower); ++i2) {
                        for (int j2 = 0; j2 <= (int)(colUpper - colLower); ++j2) {
                            blk.appendValue(cixi + i2, cixj + j2, in.quickGetValue(aixi + i2, aixj + j2));
                        }
                    }
                }
                retVal.add(new Tuple2((Object)indx, (Object)blk));
            }
        }
        return retVal.iterator();
    }

    private long getEndGlobalIndex(long blockIndex, boolean isIn, boolean isRow) {
        long len;
        long l = len = isRow ? this.rlen : this.clen;
        int blen = isIn ? (isRow ? this.in_brlen : this.in_bclen) : (isRow ? this.out_brlen : this.out_bclen);
        int new_len = UtilFunctions.computeBlockSize(len, blockIndex, blen);
        return UtilFunctions.computeCellIndex(blockIndex, blen, new_len - 1);
    }
}

