/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.sysml.parser.Expression;

public class CPOperand {
    private String _name;
    private Expression.ValueType _valueType;
    private Expression.DataType _dataType;
    private boolean _isLiteral;

    public CPOperand() {
        this("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
    }

    public CPOperand(String str) {
        this("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        this.split(str);
    }

    public CPOperand(String name, Expression.ValueType vt, Expression.DataType dt) {
        this(name, vt, dt, false);
    }

    public CPOperand(String name, Expression.ValueType vt, Expression.DataType dt, boolean literal) {
        this._name = name;
        this._valueType = vt;
        this._dataType = dt;
        this._isLiteral = literal;
    }

    public String getName() {
        return this._name;
    }

    public Expression.ValueType getValueType() {
        return this._valueType;
    }

    public Expression.DataType getDataType() {
        return this._dataType;
    }

    public boolean isMatrix() {
        return this._dataType.isMatrix();
    }

    public boolean isScalar() {
        return this._dataType.isScalar();
    }

    public boolean isLiteral() {
        return this._isLiteral;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void split(String str) {
        String[] opr = str.split("\u00b7");
        if (opr.length == 4) {
            this._name = opr[0];
            this._dataType = Expression.DataType.valueOf(opr[1]);
            this._valueType = Expression.ValueType.valueOf(opr[2]);
            this._isLiteral = Boolean.parseBoolean(opr[3]);
        } else if (opr.length == 3) {
            this._name = opr[0];
            this._dataType = Expression.DataType.valueOf(opr[1]);
            this._valueType = Expression.ValueType.valueOf(opr[2]);
            this._isLiteral = false;
        } else if (opr.length == 1) {
            this._name = opr[0];
            this._dataType = Expression.DataType.SCALAR;
            this._valueType = Expression.ValueType.DOUBLE;
            this._isLiteral = true;
        } else {
            this._name = opr[0];
            this._valueType = Expression.ValueType.valueOf(opr[1]);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

