/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MethodMetric;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.util.Contracts;

class MethodMetric
extends MutableMetric {
    private static final Log LOG = LogFactory.getLog(MethodMetric.class);
    private final Object obj;
    private final Method method;
    private final MetricsInfo info;
    private final MutableMetric impl;

    MethodMetric(Object obj, Method method, MetricsInfo info, Metric.Type type) {
        this.obj = Preconditions.checkNotNull(obj, "object");
        this.method = (Method)Contracts.checkArg((Object)method, (method.getParameterTypes().length == 0 ? 1 : 0) != 0, (Object)"Metric method should have no arguments");
        this.method.setAccessible(true);
        this.info = Preconditions.checkNotNull(info, "info");
        this.impl = this.newImpl(Preconditions.checkNotNull(type, "metric type"));
    }

    private MutableMetric newImpl(Metric.Type metricType) {
        Class<?> resType = this.method.getReturnType();
        switch (4.$SwitchMap$org$apache$hadoop$metrics2$annotation$Metric$Type[metricType.ordinal()]) {
            case 1: {
                return this.newCounter(resType);
            }
            case 2: {
                return this.newGauge(resType);
            }
            case 3: {
                return resType == String.class ? this.newTag(resType) : this.newGauge(resType);
            }
            case 4: {
                return this.newTag(resType);
            }
        }
        Contracts.checkArg((Object)((Object)metricType), (boolean)false, (Object)"unsupported metric type");
        return null;
    }

    MutableMetric newCounter(Class<?> type) {
        if (MethodMetric.isInt(type) || MethodMetric.isLong(type)) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        throw new MetricsException("Unsupported counter type: " + type.getName());
    }

    static boolean isInt(Class<?> type) {
        boolean ret = type == Integer.TYPE || type == Integer.class;
        return ret;
    }

    static boolean isLong(Class<?> type) {
        return type == Long.TYPE || type == Long.class;
    }

    static boolean isFloat(Class<?> type) {
        return type == Float.TYPE || type == Float.class;
    }

    static boolean isDouble(Class<?> type) {
        return type == Double.TYPE || type == Double.class;
    }

    MutableMetric newGauge(Class<?> t) {
        if (MethodMetric.isInt(t) || MethodMetric.isLong(t) || MethodMetric.isFloat(t) || MethodMetric.isDouble(t)) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        throw new MetricsException("Unsupported gauge type: " + t.getName());
    }

    MutableMetric newTag(Class<?> resType) {
        if (resType == String.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        throw new MetricsException("Unsupported tag type: " + resType.getName());
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        this.impl.snapshot(builder, all);
    }

    static MetricsInfo metricInfo(Method method) {
        return Interns.info(MethodMetric.nameFrom(method), "Metric for " + method.getName());
    }

    static String nameFrom(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return StringUtils.capitalize(methodName.substring(3));
        }
        return StringUtils.capitalize(methodName);
    }

    static /* synthetic */ Object access$000(MethodMetric x0) {
        return x0.obj;
    }

    static /* synthetic */ Method access$100(MethodMetric x0) {
        return x0.method;
    }

    static /* synthetic */ MetricsInfo access$200(MethodMetric x0) {
        return x0.info;
    }

    static /* synthetic */ Log access$300() {
        return LOG;
    }
}

