/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.List;
import org.apache.sysml.api.DMLException;
import org.apache.sysml.parser.common.CustomErrorListener;

public class ParseException
extends DMLException {
    private static final long serialVersionUID = 9199966053655385928L;
    private List<CustomErrorListener.ParseIssue> _parseIssues;
    private String _scriptString;
    private String _message;

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
        this._message = message;
    }

    public ParseException(String message, Exception e) {
        super(message, e);
        this._message = message;
    }

    public ParseException(List<CustomErrorListener.ParseIssue> parseIssues, String scriptString) {
        this._parseIssues = parseIssues;
        this._scriptString = scriptString;
    }

    public List<CustomErrorListener.ParseIssue> getParseIssues() {
        return this._parseIssues;
    }

    public void setParseIssues(List<CustomErrorListener.ParseIssue> parseIssues) {
        this._parseIssues = parseIssues;
    }

    public String getScriptString() {
        return this._scriptString;
    }

    public void setScriptString(String scriptString) {
        this._scriptString = scriptString;
    }

    public boolean hasParseIssues() {
        return this._parseIssues != null && this._parseIssues.size() > 0;
    }

    @Override
    public String getMessage() {
        return this.hasParseIssues() ? this.generateParseIssuesMessage() : (this._message != null ? this._message : "No parse issue message.");
    }

    private String generateParseIssuesMessage() {
        return CustomErrorListener.generateParseIssuesMessage(this._scriptString, this._parseIssues);
    }
}

