/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.AbstractPullOMDataSource;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.axiom.util.stax.WrappedTextNodeStreamReader;
import org.apache.axis2.transport.base.BaseConstants;

public class TextFileDataSource
extends AbstractPullOMDataSource {
    private final OverflowBlob overflowBlob;
    private final Charset charset;

    public TextFileDataSource(OverflowBlob overflowBlob, Charset charset) {
        this.overflowBlob = overflowBlob;
        this.charset = charset;
    }

    public static OMSourcedElement createOMSourcedElement(OverflowBlob overflowBlob, Charset charset) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        TextFileDataSource txtFileDS = new TextFileDataSource(overflowBlob, charset);
        return fac.createOMElement((OMDataSource)txtFileDS, BaseConstants.DEFAULT_TEXT_WRAPPER);
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        InputStream is;
        try {
            is = this.overflowBlob.getInputStream();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
        return new WrappedTextNodeStreamReader(BaseConstants.DEFAULT_TEXT_WRAPPER, (Reader)new InputStreamReader(is, this.charset));
    }

    public Object getObject() {
        return this.overflowBlob;
    }

    public boolean isDestructiveRead() {
        return false;
    }

    public OMDataSourceExt copy() {
        return new TextFileDataSource(this.overflowBlob, this.charset);
    }
}

