/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.message.processors.MessageProcessor;
import org.apache.synapse.util.xpath.SynapseXPath;

public class MessageProcessorSerializer {
    private static final Log log = LogFactory.getLog(MessageProcessorSerializer.class);
    public static final String FORWARDING_PROCESSOR = "org.apache.synapse.message.processors.forward.ScheduledMessageForwardingProcessor";
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public static OMElement serializeMessageProcessor(OMElement parent, MessageProcessor processor) {
        OMElement processorElem = fac.createOMElement("messageProcessor", synNS);
        if (processor != null) {
            processorElem.addAttribute(fac.createOMAttribute("class", nullNS, processor.getClass().getName()));
        } else {
            MessageProcessorSerializer.handleException("Invalid processor. Provider is required");
        }
        if (processor.getName() != null) {
            processorElem.addAttribute(fac.createOMAttribute("name", nullNS, processor.getName()));
        } else {
            MessageProcessorSerializer.handleException("Message store Name not specified");
        }
        if (FORWARDING_PROCESSOR.equals(processor.getClass().getName()) && processor.getTargetEndpoint() != null) {
            processorElem.addAttribute(fac.createOMAttribute("targetEndpoint", nullNS, processor.getTargetEndpoint()));
        }
        if (processor.getMessageStoreName() != null) {
            processorElem.addAttribute(fac.createOMAttribute("messageStore", nullNS, processor.getMessageStoreName()));
        }
        if (processor.getParameters() != null) {
            for (String name : processor.getParameters().keySet()) {
                Object object = processor.getParameters().get(name);
                OMElement property = fac.createOMElement("parameter", synNS);
                property.addAttribute(fac.createOMAttribute("name", nullNS, name));
                if (object instanceof String) {
                    String value = (String)object;
                    property.setText(value.trim());
                } else if (object instanceof SynapseXPath) {
                    SynapseXPath expression = (SynapseXPath)((Object)object);
                    SynapseXPathSerializer.serializeXPath(expression, property, "expression");
                }
                processorElem.addChild((OMNode)property);
            }
        }
        if (MessageProcessorSerializer.getSerializedDescription(processor) != null) {
            processorElem.addChild((OMNode)MessageProcessorSerializer.getSerializedDescription(processor));
        }
        if (parent != null) {
            parent.addChild((OMNode)processorElem);
        }
        return processorElem;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static OMElement getSerializedDescription(MessageProcessor processor) {
        OMElement descriptionElem = fac.createOMElement(new QName("http://ws.apache.org/ns/synapse", "description"));
        if (processor.getDescription() != null) {
            descriptionElem.setText(processor.getDescription());
            return descriptionElem;
        }
        return null;
    }
}

