/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.securevault.definition;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.securevault.commons.MiscellaneousUtil;
import org.apache.synapse.securevault.definition.IdentityKeyStoreInformation;
import org.apache.synapse.securevault.definition.KeyStoreInformation;
import org.apache.synapse.securevault.definition.TrustKeyStoreInformation;
import org.apache.synapse.securevault.secret.SecretInformationFactory;

public class KeyStoreInformationFactory {
    private static Log log = LogFactory.getLog(KeyStoreInformationFactory.class);
    private static final String IDENTITY_KEY_STORE = "keystore.identity.location";
    private static final String IDENTITY_KEY_STORE_TYPE = "keystore.identity.type";
    private static final String IDENTITY_KEY_STORE_ALIAS = "keystore.identity.alias";
    private static final String IDENTITY_KEY_STORE_PASSWORD = "keystore.identity.store";
    private static final String IDENTITY_KEY_PASSWORD = "keystore.identity.key";
    private static final String KEY_STORE_PARAMETERS = "keystore.identity.parameters";
    private static final String TRUST_STORE = "keystore.trust.location";
    private static final String TRUST_STORE_TYPE = "keystore.trust.type";
    private static final String TRUST_STORE_ALIAS = "keystore.trust.alias";
    private static final String TRUST_STORE_PASSWORD = "keystore.trust.store";
    private static final String TRUST_STORE_PARAMETERS = "keystore.trust.parameters";
    private static final String DOT = ".";
    private static final String TRUSTSTORE_PASSWORD_PROMPT = "Trust Store Password > ";
    private static final String IDENTITYSTORE_PASSWORD_PROMPT = "Identity Store Password > ";
    private static final String IDENTITYSTORE_PRIVATE_KEY_PASSWORD_PROMPT = "Identity Store Private Key Password > ";

    public static IdentityKeyStoreInformation createIdentityKeyStoreInformation(Properties properties) {
        String keyStoreLocation = MiscellaneousUtil.getProperty(properties, IDENTITY_KEY_STORE, null);
        if (keyStoreLocation == null || "".equals(keyStoreLocation)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot find a KeyStoreLocation for private key store");
            }
            return null;
        }
        IdentityKeyStoreInformation keyStoreInformation = new IdentityKeyStoreInformation();
        keyStoreInformation.setAlias(MiscellaneousUtil.getProperty(properties, IDENTITY_KEY_STORE_ALIAS, null));
        keyStoreInformation.setLocation(keyStoreLocation);
        keyStoreInformation.setStoreType(MiscellaneousUtil.getProperty(properties, IDENTITY_KEY_STORE_TYPE, null));
        keyStoreInformation.setKeyStorePasswordProvider(SecretInformationFactory.createSecretInformation(properties, "keystore.identity.store.", IDENTITYSTORE_PASSWORD_PROMPT));
        keyStoreInformation.setKeyPasswordProvider(SecretInformationFactory.createSecretInformation(properties, "keystore.identity.key.", IDENTITYSTORE_PRIVATE_KEY_PASSWORD_PROMPT));
        String parameterString = MiscellaneousUtil.getProperty(properties, KEY_STORE_PARAMETERS, null);
        KeyStoreInformationFactory.parseParameter(parameterString, keyStoreInformation);
        return keyStoreInformation;
    }

    public static TrustKeyStoreInformation createTrustKeyStoreInformation(Properties properties) {
        String keyStoreLocation = MiscellaneousUtil.getProperty(properties, TRUST_STORE, null);
        if (keyStoreLocation == null || "".equals(keyStoreLocation)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot find a KeyStoreLocation for trust store");
            }
            return null;
        }
        TrustKeyStoreInformation trustInformation = new TrustKeyStoreInformation();
        trustInformation.setAlias(MiscellaneousUtil.getProperty(properties, TRUST_STORE_ALIAS, null));
        trustInformation.setLocation(keyStoreLocation);
        trustInformation.setStoreType(MiscellaneousUtil.getProperty(properties, TRUST_STORE_TYPE, null));
        trustInformation.setKeyStorePasswordProvider(SecretInformationFactory.createSecretInformation(properties, "keystore.trust.store.", TRUSTSTORE_PASSWORD_PROMPT));
        String parameterString = MiscellaneousUtil.getProperty(properties, TRUST_STORE_PARAMETERS, null);
        KeyStoreInformationFactory.parseParameter(parameterString, trustInformation);
        return trustInformation;
    }

    private static void parseParameter(String parameterString, KeyStoreInformation information) {
        if (parameterString == null || "".equals(parameterString)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No additional parameter for KeyStore");
            }
            return;
        }
        String[] parameterPairs = parameterString.split(";");
        if (parameterPairs == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No additional parameter for KeyStore");
            }
            return;
        }
        for (String parameterPairString : parameterPairs) {
            String[] values = parameterPairString.split("=");
            if (values == null || values.length != 2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"A parameter with no (name,value) pair has been found ");
                }
                return;
            }
            information.addParameter(values[0], values[1]);
        }
    }
}

