/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.util;

import javax.xml.namespace.QName;

public class PolicyInfo {
    private String policyKey;
    private int type;
    private QName operation;
    public static final int MESSAGE_TYPE_IN = 1;
    public static final int MESSAGE_TYPE_OUT = 2;

    public PolicyInfo(String policyKey) {
        this.policyKey = policyKey;
    }

    public PolicyInfo(String policyKey, int type) {
        this.policyKey = policyKey;
        this.type = type;
    }

    public PolicyInfo(String policyKey, QName operation) {
        this.policyKey = policyKey;
        this.operation = operation;
    }

    public PolicyInfo(String policyKey, int type, QName operation) {
        this.policyKey = policyKey;
        this.type = type;
        this.operation = operation;
    }

    public boolean isServicePolicy() {
        return this.policyKey != null && this.type == 0 && this.operation == null;
    }

    public boolean isOperationPolicy() {
        return this.policyKey != null && this.type == 0 && this.operation != null;
    }

    public boolean isMessagePolicy() {
        return this.policyKey != null && this.type != 0;
    }

    public String getMessageLable() {
        if (this.type == 1) {
            return "In";
        }
        if (this.type == 2) {
            return "Out";
        }
        return null;
    }

    public String getPolicyKey() {
        return this.policyKey;
    }

    public void setPolicyKey(String policyKey) {
        this.policyKey = policyKey;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public QName getOperation() {
        return this.operation;
    }

    public void setOperation(QName operation) {
        this.operation = operation;
    }
}

