/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.conn.logging;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;

public class LoggingServerEventHandler
implements NHttpServerEventHandler {
    private final Log log;
    private final NHttpServerEventHandler handler;

    public LoggingServerEventHandler(NHttpServerEventHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP service handler must not be null");
        }
        this.handler = handler;
        this.log = LogFactory.getLog(handler.getClass());
    }

    public void connected(NHttpServerConnection conn) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Connected"));
        }
        this.handler.connected(conn);
    }

    public void closed(NHttpServerConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Closed"));
        }
        this.handler.closed(conn);
    }

    public void endOfInput(NHttpServerConnection conn) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Closed at the remote end"));
        }
        this.handler.endOfInput(conn);
    }

    public void exception(NHttpServerConnection conn, Exception ex) {
        this.handler.exception(conn, ex);
    }

    public void requestReceived(NHttpServerConnection conn) throws IOException, HttpException {
        HttpRequest request = conn.getHttpRequest();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP InRequest Received on connection " + conn + ": " + request.getRequestLine()));
        }
        this.handler.requestReceived(conn);
    }

    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Output ready"));
        }
        this.handler.outputReady(conn, encoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Content encoder " + encoder));
        }
    }

    public void responseReady(NHttpServerConnection conn) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Response ready"));
        }
        this.handler.responseReady(conn);
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Input ready"));
        }
        this.handler.inputReady(conn, decoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Content decoder " + decoder));
        }
    }

    public void timeout(NHttpServerConnection conn) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Timeout"));
        }
        this.handler.timeout(conn);
    }
}

