/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.validator;

import javax.xml.namespace.QName;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.signature.SPKIData;
import org.opensaml.xml.signature.SPKISexp;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPKIDataSchemaValidator
implements Validator<SPKIData> {
    @Override
    public void validate(SPKIData xmlObject) throws ValidationException {
        this.validateChildrenPresence(xmlObject);
        this.validateChildrenNamespaces(xmlObject);
    }

    protected void validateChildrenPresence(SPKIData xmlObject) throws ValidationException {
        if (xmlObject.getSPKISexps().isEmpty()) {
            throw new ValidationException("SPKIData does not contain at least one SPKISexp child");
        }
    }

    protected void validateChildrenNamespaces(SPKIData xmlObject) throws ValidationException {
        for (XMLObject child : xmlObject.getXMLObjects()) {
            QName childName = child.getElementQName();
            if (SPKISexp.DEFAULT_ELEMENT_NAME.equals(childName) || !"http://www.w3.org/2000/09/xmldsig#".equals(childName.getNamespaceURI())) continue;
            throw new ValidationException("PGPData contains an illegal child extension element: " + childName);
        }
    }
}

