/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;

public class DataSourceFinder {
    private static Log log = LogFactory.getLog(DataSourceFinder.class);

    public static DataSource find(String dsName, Properties jndiEnv) {
        try {
            InitialContext context = jndiEnv == null ? new InitialContext() : new InitialContext(jndiEnv);
            return DataSourceFinder.find(dsName, context);
        }
        catch (NamingException e) {
            throw new SynapseCommonsException("Error looking up DataSource : " + dsName + " using JNDI properties : " + jndiEnv, e, log);
        }
    }

    public static DataSource find(String dsName, Context context) {
        try {
            Object dataSourceO = context.lookup(dsName);
            if (dataSourceO != null && dataSourceO instanceof DataSource) {
                return (DataSource)dataSourceO;
            }
            throw new SynapseCommonsException("DataSource : " + dsName + " not found when looking up using JNDI properties : " + context.getEnvironment(), log);
        }
        catch (NamingException e) {
            throw new SynapseCommonsException("Error looking up DataSource : " + dsName + " using JNDI properties : " + context, e, log);
        }
    }
}

