/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jep;

import com.sun.script.jep.ConstructorCommand;
import com.sun.script.jep.InvocableCommand;
import com.sun.script.jep.JepScriptEngineFactory;
import com.sun.script.jep.MethodCommand;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.lsmp.djep.groupJep.GroupI;
import org.lsmp.djep.groupJep.GroupJep;
import org.lsmp.djep.groupJep.groups.BigReals;
import org.lsmp.djep.groupJep.groups.Integers;
import org.lsmp.djep.groupJep.groups.Quaternions;
import org.lsmp.djep.groupJep.groups.Rationals;
import org.lsmp.djep.groupJep.groups.Reals;
import org.lsmp.djep.groupJep.groups.Zn;
import org.lsmp.djep.vectorJep.VectorJep;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.PostfixMathCommandI;

public class JepScriptEngine
extends AbstractScriptEngine
implements Compilable {
    public static final String JEP_MODE = "jep.mode";
    private volatile ScriptEngineFactory factory;

    public JepScriptEngine() {
        this((ScriptEngineFactory)null);
    }

    JepScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.eval(this.readFully(reader), this.context);
    }

    public Object eval(String script, ScriptContext ctx) throws ScriptException {
        JEP jep = this.getContextJep(ctx);
        Node node = this.parse(jep, script);
        return this.evaluate(jep, node);
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            JepScriptEngine jepScriptEngine = this;
            synchronized (jepScriptEngine) {
                if (this.factory == null) {
                    this.factory = new JepScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }

    public CompiledScript compile(String script) throws ScriptException {
        JEP jep = this.getContextJep(this.context);
        Node node = this.parse(jep, script);
        return new JepCompiledScript(node);
    }

    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    private Node parse(JEP jep, String str) throws ScriptException {
        try {
            return jep.parse(str);
        }
        catch (ParseException pe) {
            throw new ScriptException((Exception)((Object)pe));
        }
    }

    private Object evaluate(JEP jep, Node node) throws ScriptException {
        try {
            return jep.evaluate(node);
        }
        catch (ParseException pe) {
            throw new ScriptException((Exception)((Object)pe));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private JEP getContextJep(final ScriptContext ctx) {
        JEP jep;
        block6: {
            block7: {
                String mode;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    ctx.setAttribute("context", ctx, 100);
                                    Object tmp = ctx.getAttribute(JEP_MODE);
                                    if (tmp instanceof JEP) {
                                        JEP jep2 = (JEP)tmp;
                                        this.importEngineBindings(jep2, ctx);
                                        return jep2;
                                    }
                                    if (!(tmp instanceof String)) break block7;
                                    mode = (String)tmp;
                                    if (!mode.equals("complex")) break block8;
                                    jep = new JEP();
                                    jep.addComplex();
                                    break block6;
                                }
                                if (!mode.equals("integer")) break block9;
                                jep = new GroupJep((GroupI)new Integers());
                                break block6;
                            }
                            if (!mode.equals("real")) break block10;
                            jep = new GroupJep((GroupI)new Reals());
                            break block6;
                        }
                        if (!mode.equals("bigreal")) break block11;
                        jep = new GroupJep((GroupI)new BigReals(1));
                        break block6;
                    }
                    if (!mode.equals("rational")) break block12;
                    jep = new GroupJep((GroupI)new Rationals());
                    break block6;
                }
                if (mode.equals("quarternion")) {
                    jep = new GroupJep((GroupI)new Quaternions());
                    break block6;
                } else if (mode.equals("vector")) {
                    jep = new VectorJep();
                    break block6;
                } else {
                    if (!mode.startsWith("z") && !mode.startsWith("Z")) {
                        ctx.setAttribute(JEP_MODE, null, 100);
                        throw new RuntimeException("unsupported mode: " + mode);
                    }
                    String mod = mode.substring(1);
                    jep = new GroupJep((GroupI)new Zn(new BigInteger(mod)));
                }
                break block6;
            }
            jep = new JEP();
        }
        jep.setAllowAssignment(true);
        jep.setAllowUndeclared(true);
        jep.addStandardFunctions();
        jep.addStandardConstants();
        jep.addFunction("mode", (PostfixMathCommandI)new ModeCommand(ctx));
        Observer observer = new Observer(){
            static final /* synthetic */ boolean $assertionsDisabled;
            private static final /* synthetic */ Class class$com$sun$script$jep$JepScriptEngine;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update(Observable arg0, Object arg1) {
                Variable var;
                if (arg0 instanceof Variable) {
                    var = (Variable)arg0;
                } else if (arg0 instanceof SymbolTable.StObservable) {
                    var = (Variable)arg1;
                    var.addObserver((Observer)this);
                } else {
                    return;
                }
                if (!$assertionsDisabled && var == null) {
                    throw new AssertionError((Object)"huh! null Variable?");
                }
                if (var.isConstant()) {
                    return;
                }
                String name = var.getName();
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    int scope = ctx.getAttributesScope(name);
                    if (scope == -1) {
                        scope = 100;
                    }
                    ctx.setAttribute(name, var.getValue(), scope);
                }
            }

            static {
                $assertionsDisabled = !(class$com$sun$script$jep$JepScriptEngine == null ? (class$com$sun$script$jep$JepScriptEngine = 1.class$("com.sun.script.jep.JepScriptEngine")) : class$com$sun$script$jep$JepScriptEngine).desiredAssertionStatus();
            }

            static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
                Class<?> clazz;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
                    try {
                        noClassDefFoundError.initCause(classNotFoundException);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    throw noClassDefFoundError;
                }
                return clazz;
            }
        };
        jep.getSymbolTable().addObserverToExistingVariables(observer);
        jep.getSymbolTable().addObserver(observer);
        this.importEngineBindings(jep, ctx);
        ctx.setAttribute(JEP_MODE, jep, 100);
        return jep;
    }

    private void importEngineBindings(JEP jep, ScriptContext ctx) {
        Bindings bindings = ctx.getBindings(100);
        Iterator i$ = bindings.keySet().iterator();
        while (i$.hasNext()) {
            String key = (String)i$.next();
            Object value = bindings.get(key);
            if (value instanceof PostfixMathCommandI) {
                jep.addFunction(key, (PostfixMathCommandI)value);
                continue;
            }
            if (value instanceof Method) {
                Method m = (Method)value;
                jep.addFunction(key, (PostfixMathCommandI)new MethodCommand(m));
                continue;
            }
            if (value instanceof Constructor) {
                Constructor c = (Constructor)value;
                jep.addFunction(key, (PostfixMathCommandI)new ConstructorCommand(c));
                continue;
            }
            if (value instanceof Invocable) {
                jep.addFunction(key, (PostfixMathCommandI)new InvocableCommand((Invocable)value, key));
                continue;
            }
            Variable var = jep.getVar(key);
            if (var != null && var.isConstant()) continue;
            jep.addVariable(key, bindings.get(key));
        }
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuffer buf = new StringBuffer();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }

    static JEP access$000(JepScriptEngine x0, ScriptContext x1) {
        return x0.getContextJep(x1);
    }

    static Object access$100(JepScriptEngine x0, JEP x1, Node x2) throws ScriptException {
        return x0.evaluate(x1, x2);
    }

    private class ModeCommand
    extends PostfixMathCommand {
        private ScriptContext ctx;

        public ModeCommand(ScriptContext ctx) {
            this.ctx = ctx;
            this.numberOfParameters = 1;
        }

        public void run(Stack s) throws ParseException {
            this.checkStack(s);
            String mode = s.pop().toString();
            this.ctx.setAttribute(JepScriptEngine.JEP_MODE, mode, 100);
            JepScriptEngine.access$000(JepScriptEngine.this, this.ctx);
            s.push(null);
        }
    }

    private class JepCompiledScript
    extends CompiledScript {
        private Node node;

        JepCompiledScript(Node node) {
            this.node = node;
        }

        public Object eval(ScriptContext ctx) throws ScriptException {
            JEP jep = JepScriptEngine.access$000(JepScriptEngine.this, ctx);
            return JepScriptEngine.access$100(JepScriptEngine.this, jep, this.node);
        }

        public ScriptEngine getEngine() {
            return JepScriptEngine.this;
        }
    }
}

