/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform.url;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.transform.url.URIFragments;
import org.apache.synapse.util.xpath.SynapseXPath;

public class RewriteAction {
    private static final Log log = LogFactory.getLog(RewriteAction.class);
    public static final int ACTION_SET = 0;
    public static final int ACTION_APPEND = 1;
    public static final int ACTION_PREPEND = 2;
    public static final int ACTION_REPLACE = 3;
    public static final int ACTION_REMOVE = 4;
    private String value;
    private SynapseXPath xpath;
    private String regex;
    private int fragmentIndex = -2;
    private int actionType = 0;

    public void execute(URIFragments fragments, MessageContext messageContext) throws URISyntaxException {
        String result;
        if (this.xpath != null) {
            result = this.xpath.stringValueOf(messageContext);
            if (result == null) {
                result = "";
            }
        } else {
            result = this.value;
        }
        if (this.fragmentIndex == -2) {
            URI uri;
            if (result != null) {
                uri = new URI(result);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Setting the URI to: " + result));
                }
            } else {
                uri = new URI("");
            }
            fragments.setFragments(uri);
        } else if (this.fragmentIndex == -1) {
            if (result != null) {
                fragments.setPort(Integer.parseInt(result));
            } else {
                fragments.setPort(-1);
            }
        } else {
            String str;
            String currentValue = fragments.getStringFragment(this.fragmentIndex);
            if (currentValue == null) {
                currentValue = "";
            }
            switch (this.actionType) {
                case 2: {
                    str = result.concat(currentValue);
                    break;
                }
                case 1: {
                    str = currentValue.concat(result);
                    break;
                }
                case 3: {
                    str = currentValue.replaceAll(this.regex, result);
                    break;
                }
                case 4: {
                    str = null;
                    break;
                }
                default: {
                    str = result;
                }
            }
            fragments.setStringFragment(this.fragmentIndex, str);
        }
    }

    public int getFragmentIndex() {
        return this.fragmentIndex;
    }

    public void setFragmentIndex(int fragmentIndex) {
        this.fragmentIndex = fragmentIndex;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SynapseXPath getXpath() {
        return this.xpath;
    }

    public void setXpath(SynapseXPath xpath) {
        this.xpath = xpath;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public int getActionType() {
        return this.actionType;
    }

    public void setActionType(int actionType) {
        this.actionType = actionType;
    }
}

