/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.endpoints.EndpointDefinitionSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.DefaultEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;

public class DefaultEndpointSerializer
extends EndpointSerializer {
    @Override
    protected OMElement serializeEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof DefaultEndpoint)) {
            this.handleException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        DefaultEndpoint defaultEndpoint = (DefaultEndpoint)endpoint;
        this.serializeCommonAttributes(defaultEndpoint, endpointElement);
        EndpointDefinition epAddress = defaultEndpoint.getDefinition();
        OMElement defaultElement = this.serializeEndpointDefinition(epAddress);
        endpointElement.addChild((OMNode)defaultElement);
        this.serializeProperties(defaultEndpoint, endpointElement);
        return endpointElement;
    }

    @Override
    protected void serializeSpecificEndpointProperties(EndpointDefinition endpointDefinition, OMElement element) {
        if ("pox".equals(endpointDefinition.getFormat())) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "pox"));
        } else if ("get".equals(endpointDefinition.getFormat())) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "get"));
        } else if ("soap11".equals(endpointDefinition.getFormat())) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "soap11"));
        } else if ("soap12".equals(endpointDefinition.getFormat())) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "soap12"));
        } else if ("rest".equals(endpointDefinition.getFormat())) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "rest"));
        } else if (endpointDefinition.isForcePOX()) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "pox"));
        } else if (endpointDefinition.isForceGET()) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "get"));
        } else if (endpointDefinition.isForceSOAP11()) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "soap11"));
        } else if (endpointDefinition.isForceSOAP12()) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "soap12"));
        } else if (endpointDefinition.isForceREST()) {
            element.addAttribute(this.fac.createOMAttribute("format", null, "rest"));
        }
    }

    public OMElement serializeEndpointDefinition(EndpointDefinition endpointDefinition) {
        EndpointDefinitionSerializer serializer = new EndpointDefinitionSerializer();
        OMElement element = this.fac.createOMElement("default", SynapseConstants.SYNAPSE_OMNAMESPACE);
        serializer.serializeEndpointDefinition(endpointDefinition, element);
        this.serializeSpecificEndpointProperties(endpointDefinition, element);
        return element;
    }
}

