/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.util.Date;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SecretManagerAdminMBeanImpl;
import org.apache.synapse.ServerConfigurationInformation;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.ServerManagerView;
import org.apache.synapse.ServerState;
import org.apache.synapse.ServerStateDetectionStrategy;
import org.apache.synapse.SynapseController;
import org.apache.synapse.SynapseControllerFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.securevault.PasswordManager;

public class ServerManager {
    private static final Log log = LogFactory.getLog(ServerManager.class);
    private SynapseController synapseController;
    private ServerConfigurationInformation serverConfigurationInformation;
    private ServerContextInformation serverContextInformation;
    private boolean initialized = false;
    private ClassLoader classLoader;

    public synchronized ServerState init(ServerConfigurationInformation serverConfigurationInformation, ServerContextInformation serverContextInformation) {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.serverConfigurationInformation = serverConfigurationInformation;
        this.serverContextInformation = serverContextInformation == null ? new ServerContextInformation(serverConfigurationInformation) : serverContextInformation;
        this.synapseController = SynapseControllerFactory.createSynapseController(serverConfigurationInformation);
        this.doInit();
        this.initialized = true;
        return this.serverContextInformation.getServerState();
    }

    public synchronized ServerState shutdown() {
        ServerState serverState = ServerStateDetectionStrategy.currentState(this.serverContextInformation, this.serverConfigurationInformation);
        switch (serverState) {
            case INITIALIZED: {
                this.doShutdown();
                break;
            }
            case STOPPED: {
                this.doShutdown();
                break;
            }
            case STARTED: {
                this.stop();
                this.doShutdown();
                break;
            }
            case MAINTENANCE: {
                this.stop();
                this.doShutdown();
            }
        }
        this.synapseController = null;
        this.serverContextInformation = null;
        this.serverConfigurationInformation = null;
        this.initialized = false;
        return ServerState.UNDETERMINED;
    }

    public synchronized ServerState start() {
        this.assertInitialized();
        ServerState serverState = ServerStateDetectionStrategy.currentState(this.serverContextInformation, this.serverConfigurationInformation);
        if (serverState == ServerState.INITIALIZED || serverState == ServerState.STOPPED) {
            this.serverContextInformation.setSynapseConfiguration(this.synapseController.createSynapseConfiguration());
            this.serverContextInformation.setSynapseEnvironment(this.synapseController.createSynapseEnvironment());
            this.synapseController.start();
            this.changeState(ServerState.STARTED);
            log.info((Object)"Server ready for processing...");
        } else if (serverState == ServerState.STARTED) {
            String message = "The server has already been started.";
            this.handleException(message);
        } else if (serverState == ServerState.MAINTENANCE) {
            this.endMaintenance();
        } else {
            this.changeState(serverState);
        }
        return this.serverContextInformation.getServerState();
    }

    public synchronized ServerState startMaintenance() {
        this.assertInitialized();
        ServerState serverState = ServerStateDetectionStrategy.currentState(this.serverContextInformation, this.serverConfigurationInformation);
        if (serverState == ServerState.STARTED) {
            this.synapseController.startMaintenance();
            this.changeState(ServerState.MAINTENANCE);
        } else if (serverState == ServerState.MAINTENANCE) {
            String message = "The server is already in maintenance mode.";
            this.handleException(message);
        } else {
            String message = "Couldn't enter maintenance mode, the server has not been started.";
            this.handleException(message);
        }
        return this.serverContextInformation.getServerState();
    }

    public synchronized ServerState endMaintenance() {
        this.assertInitialized();
        ServerState serverState = ServerStateDetectionStrategy.currentState(this.serverContextInformation, this.serverConfigurationInformation);
        if (serverState == ServerState.MAINTENANCE) {
            this.synapseController.endMaintenance();
            this.changeState(ServerState.STARTED);
        } else {
            String message = "Couldn't leave maintenance mode. The server has not been in maintenance.";
            this.handleException(message);
        }
        return this.serverContextInformation.getServerState();
    }

    public synchronized ServerState stop() {
        this.assertInitialized();
        ServerState serverState = ServerStateDetectionStrategy.currentState(this.serverContextInformation, this.serverConfigurationInformation);
        if (serverState == ServerState.STARTED || serverState == ServerState.MAINTENANCE) {
            this.synapseController.stop();
            this.synapseController.destroySynapseEnvironment();
            this.serverContextInformation.setSynapseEnvironment(null);
            this.synapseController.destroySynapseConfiguration();
            this.serverContextInformation.setSynapseConfiguration(null);
            this.changeState(ServerState.STOPPED);
        } else {
            this.changeState(serverState);
            String message = "Couldn't stop the ServerManager, it has not been started yet";
            this.handleException(message);
        }
        return this.serverContextInformation.getServerState();
    }

    public synchronized ServerState stopGracefully(long maxWaitMillis) {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + maxWaitMillis;
        long waitIntervalMillis = 2000L;
        log.info((Object)("Requesting a graceful shutdown at: " + new Date() + " in a maximum of " + maxWaitMillis / 1000L + " seconds."));
        this.startMaintenance();
        if (this.synapseController.waitUntilSafeToStop(2000L, endTime)) {
            log.info((Object)("The instance could not be gracefully stopped in: " + maxWaitMillis / 1000L + " seconds. Performing an immediate stop..."));
        }
        this.stop();
        log.info((Object)("Graceful stop request completed in " + (System.currentTimeMillis() - startTime) + " milliseconds."));
        return this.serverContextInformation.getServerState();
    }

    public ServerConfigurationInformation getServerConfigurationInformation() {
        this.assertInitialized();
        return this.serverConfigurationInformation;
    }

    public ServerContextInformation getServerContextInformation() {
        this.assertInitialized();
        return this.serverContextInformation;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public ServerState getServerState() {
        if (this.serverContextInformation != null) {
            return this.serverContextInformation.getServerState();
        }
        return ServerState.UNDETERMINED;
    }

    private void doInit() {
        ServerState serverState = ServerStateDetectionStrategy.currentState(this.serverContextInformation, this.serverConfigurationInformation);
        if (serverState == ServerState.INITIALIZABLE) {
            this.registerMBean();
            PasswordManager.getInstance().init(SynapsePropertiesLoader.loadSynapseProperties(), "synapse");
            this.synapseController.init(this.serverConfigurationInformation, this.serverContextInformation);
            this.changeState(ServerState.INITIALIZED);
        } else {
            this.changeState(serverState);
        }
    }

    private void doShutdown() {
        ServerState serverState = ServerStateDetectionStrategy.currentState(this.serverContextInformation, this.serverConfigurationInformation);
        if (serverState == ServerState.INITIALIZED || serverState == ServerState.STOPPED) {
            PasswordManager passwordManager = PasswordManager.getInstance();
            if (passwordManager.isInitialized()) {
                PasswordManager.getInstance().shutDown();
            }
            this.unRegisterMBean();
            this.synapseController.destroy();
            this.changeState(ServerState.UNDETERMINED);
        } else {
            this.changeState(serverState);
        }
    }

    private void changeState(ServerState serverState) {
        this.serverContextInformation.setServerState(serverState);
    }

    private void assertInitialized() {
        if (!this.initialized) {
            String msg = "Server manager has not been initialized, it requires to be initialized, with the required configurations before starting";
            this.handleException(msg);
        }
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private void registerMBean() {
        MBeanRegistrar.getInstance().registerMBean((Object)new ServerManagerView(this), "ServerManager", "ServerManager");
        try {
            MBeanRegistrar.getInstance().registerMBean((Object)new SecretManagerAdminMBeanImpl(), "SecurityAdminServices", "SecretManagerAdmin");
        }
        catch (NotCompliantMBeanException e) {
            this.handleException("Error registering SecretManagerAdminMBeanImpl", e);
        }
    }

    private void unRegisterMBean() {
        MBeanRegistrar.getInstance().unRegisterMBean("ServerManager", "ServerManager");
        MBeanRegistrar.getInstance().unRegisterMBean("SecurityAdminServices", "SecretManagerAdmin");
    }
}

