/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import * as CategoricalColorNamespace from './CategoricalColorNamespace';

export { CategoricalColorNamespace };
export { default as CategoricalColorScale } from './CategoricalColorScale';
export { default as CategoricalScheme } from './CategoricalScheme';
export * from './CategoricalScheme';
export { default as getCategoricalSchemeRegistry } from './CategoricalSchemeRegistrySingleton';
export { default as ColorScheme } from './ColorScheme';
export * from './ColorScheme';
export { default as getSequentialSchemeRegistry } from './SequentialSchemeRegistrySingleton';
export { default as SequentialScheme } from './SequentialScheme';
export * from './SequentialScheme';
export { default as ColorSchemeRegistry } from './ColorSchemeRegistry';
export * from './colorSchemes';
export * from './utils';
export * from './types';
export {
  default as getSharedLabelColor,
  SharedLabelColor,
  SharedLabelColorSource,
} from './SharedLabelColorSingleton';

export const BRAND_COLOR = '#00A699';
