/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts2.test;

import org.apache.struts2.SimpleAnnotationAction;
import org.apache.struts2.util.Bar;
import org.apache.struts2.interceptor.parameter.StrutsParameter;


/**
 * Extend SimpleAction to test class hierarchy traversal.
 *
 * @author Mark Woon
 * @author Rainer Hermanns
 */
public class SimpleAnnotationAction3 extends SimpleAnnotationAction implements AnnotationDataAware {

    private Bar bar;
    private String data;

    @Override
    public void setBarObj(Bar b) {
        bar = b;
    }

    @StrutsParameter(depth = 1)
    @Override
    public Bar getBarObj() {
        return bar;
    }

    @StrutsParameter
    @Override
    public void setData(String data) {
        this.data = data;
    }

    @Override
    public String getData() {
        return data;
    }
}
