/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.streampark.common.conf.ConfigConst;
import org.apache.streampark.common.conf.Workspace;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.fs.FsOperator;
import org.apache.streampark.common.util.FileUtils;
import org.apache.streampark.common.util.ThreadUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.core.bean.DockerConfig;
import org.apache.streampark.console.core.entity.AppBuildPipeline;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ApplicationConfig;
import org.apache.streampark.console.core.entity.ApplicationLog;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.entity.FlinkSql;
import org.apache.streampark.console.core.entity.Message;
import org.apache.streampark.console.core.enums.CandidateType;
import org.apache.streampark.console.core.enums.NoticeType;
import org.apache.streampark.console.core.enums.OptionState;
import org.apache.streampark.console.core.enums.ReleaseState;
import org.apache.streampark.console.core.enums.ResourceFrom;
import org.apache.streampark.console.core.mapper.ApplicationBuildPipelineMapper;
import org.apache.streampark.console.core.service.AppBuildPipeService;
import org.apache.streampark.console.core.service.ApplicationBackUpService;
import org.apache.streampark.console.core.service.ApplicationConfigService;
import org.apache.streampark.console.core.service.ApplicationLogService;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.apache.streampark.console.core.service.FlinkSqlService;
import org.apache.streampark.console.core.service.MessageService;
import org.apache.streampark.console.core.service.ServiceHelper;
import org.apache.streampark.console.core.service.SettingService;
import org.apache.streampark.console.core.task.FlinkAppHttpWatcher;
import org.apache.streampark.flink.packer.docker.DockerConf;
import org.apache.streampark.flink.packer.maven.Artifact;
import org.apache.streampark.flink.packer.maven.MavenTool;
import org.apache.streampark.flink.packer.pipeline.BuildPipeline;
import org.apache.streampark.flink.packer.pipeline.BuildResult;
import org.apache.streampark.flink.packer.pipeline.DockerBuildSnapshot;
import org.apache.streampark.flink.packer.pipeline.DockerProgressWatcher;
import org.apache.streampark.flink.packer.pipeline.DockerPullSnapshot;
import org.apache.streampark.flink.packer.pipeline.DockerPushSnapshot;
import org.apache.streampark.flink.packer.pipeline.DockerResolvedSnapshot;
import org.apache.streampark.flink.packer.pipeline.FlinkK8sApplicationBuildRequest;
import org.apache.streampark.flink.packer.pipeline.FlinkK8sSessionBuildRequest;
import org.apache.streampark.flink.packer.pipeline.FlinkRemotePerJobBuildRequest;
import org.apache.streampark.flink.packer.pipeline.FlinkYarnApplicationBuildRequest;
import org.apache.streampark.flink.packer.pipeline.PipeSnapshot;
import org.apache.streampark.flink.packer.pipeline.PipeWatcher;
import org.apache.streampark.flink.packer.pipeline.PipelineStatus;
import org.apache.streampark.flink.packer.pipeline.PipelineType;
import org.apache.streampark.flink.packer.pipeline.impl.FlinkK8sApplicationBuildPipeline;
import org.apache.streampark.flink.packer.pipeline.impl.FlinkK8sSessionBuildPipeline;
import org.apache.streampark.flink.packer.pipeline.impl.FlinkRemoteBuildPipeline;
import org.apache.streampark.flink.packer.pipeline.impl.FlinkYarnApplicationBuildPipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
public class AppBuildPipeServiceImpl
extends ServiceImpl<ApplicationBuildPipelineMapper, AppBuildPipeline>
implements AppBuildPipeService {
    private static final Logger log = LoggerFactory.getLogger(AppBuildPipeServiceImpl.class);
    @Autowired
    private FlinkEnvService flinkEnvService;
    @Autowired
    private FlinkSqlService flinkSqlService;
    @Autowired
    private ApplicationBackUpService backUpService;
    @Autowired
    private ServiceHelper serviceHelper;
    @Autowired
    private SettingService settingService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private FlinkClusterService flinkClusterService;
    @Autowired
    private ApplicationLogService applicationLogService;
    @Autowired
    private FlinkAppHttpWatcher flinkAppHttpWatcher;
    @Autowired
    private ApplicationConfigService applicationConfigService;
    private static final Cache<Long, DockerPullSnapshot> DOCKER_PULL_PG_SNAPSHOTS = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.DAYS).build();
    private static final Cache<Long, DockerBuildSnapshot> DOCKER_BUILD_PG_SNAPSHOTS = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.DAYS).build();
    private static final Cache<Long, DockerPushSnapshot> DOCKER_PUSH_PG_SNAPSHOTS = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.DAYS).build();
    private static final int CPU_NUM = Math.max(4, Runtime.getRuntime().availableProcessors() * 2);
    private final ExecutorService buildPipelineExecutor = new ThreadPoolExecutor(1, CPU_NUM, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.threadFactory((String)"streampark-flink-buildPipeline"));

    @PreDestroy
    public void shutdown() {
        this.buildPipelineExecutor.shutdown();
    }

    @Override
    public boolean buildApplication(final @Nonnull Application app, final ApplicationLog applicationLog) {
        final FlinkSql newFlinkSql = this.flinkSqlService.getCandidate(app.getId(), CandidateType.NEW);
        FlinkSql effectiveFlinkSql = this.flinkSqlService.getEffective(app.getId(), false);
        if (app.isFlinkSqlJob()) {
            FlinkSql flinkSql = newFlinkSql == null ? effectiveFlinkSql : newFlinkSql;
            Utils.notNull((Object)flinkSql);
            app.setDependency(flinkSql.getDependency());
        }
        BuildPipeline pipeline = this.createPipelineInstance(app);
        this.removeApp(app.getId());
        pipeline.registerWatcher(new PipeWatcher(){

            public void onStart(PipeSnapshot snapshot) throws Exception {
                AppBuildPipeline buildPipeline = AppBuildPipeline.fromPipeSnapshot(snapshot).setAppId(app.getId());
                AppBuildPipeServiceImpl.this.saveEntity(buildPipeline);
                app.setRelease(ReleaseState.RELEASING.get());
                AppBuildPipeServiceImpl.this.applicationService.updateRelease(app);
                if (AppBuildPipeServiceImpl.this.flinkAppHttpWatcher.isWatchingApp(app.getId())) {
                    AppBuildPipeServiceImpl.this.flinkAppHttpWatcher.initialize();
                }
                AppBuildPipeServiceImpl.this.applicationService.checkEnv(app);
                AppBuildPipeServiceImpl.this.prepareJars(app);
            }

            public void onStepStateChange(PipeSnapshot snapshot) {
                AppBuildPipeline buildPipeline = AppBuildPipeline.fromPipeSnapshot(snapshot).setAppId(app.getId());
                AppBuildPipeServiceImpl.this.saveEntity(buildPipeline);
            }

            public void onFinish(PipeSnapshot snapshot, BuildResult result) {
                AppBuildPipeline buildPipeline = AppBuildPipeline.fromPipeSnapshot(snapshot).setAppId(app.getId()).setBuildResult(result);
                AppBuildPipeServiceImpl.this.saveEntity(buildPipeline);
                if (result.pass()) {
                    if (app.isRunning()) {
                        app.setRelease(ReleaseState.NEED_RESTART.get());
                    } else {
                        ApplicationConfig config;
                        app.setOptionState(OptionState.NONE.getValue());
                        app.setRelease(ReleaseState.DONE.get());
                        if (app.isFlinkSqlJob()) {
                            AppBuildPipeServiceImpl.this.applicationService.toEffective(app);
                        } else if (app.isStreamParkJob() && (config = AppBuildPipeServiceImpl.this.applicationConfigService.getLatest(app.getId())) != null) {
                            config.setToApplication(app);
                            AppBuildPipeServiceImpl.this.applicationConfigService.toEffective(app.getId(), app.getConfigId());
                        }
                    }
                    if (!app.isNeedRollback()) {
                        if (app.isFlinkSqlJob() && newFlinkSql != null) {
                            AppBuildPipeServiceImpl.this.backUpService.backup(app, newFlinkSql);
                        } else {
                            AppBuildPipeServiceImpl.this.backUpService.backup(app, null);
                        }
                    }
                    applicationLog.setSuccess(true);
                    app.setBuild(false);
                } else {
                    Message message = new Message(AppBuildPipeServiceImpl.this.serviceHelper.getUserId(), app.getId(), app.getJobName().concat(" release failed"), Utils.stringifyException((Throwable)snapshot.error().exception()), NoticeType.EXCEPTION);
                    AppBuildPipeServiceImpl.this.messageService.push(message);
                    app.setRelease(ReleaseState.FAILED.get());
                    app.setOptionState(OptionState.NONE.getValue());
                    app.setBuild(true);
                    applicationLog.setException(Utils.stringifyException((Throwable)snapshot.error().exception()));
                    applicationLog.setSuccess(false);
                }
                AppBuildPipeServiceImpl.this.applicationService.updateRelease(app);
                AppBuildPipeServiceImpl.this.applicationLogService.save(applicationLog);
                if (AppBuildPipeServiceImpl.this.flinkAppHttpWatcher.isWatchingApp(app.getId())) {
                    AppBuildPipeServiceImpl.this.flinkAppHttpWatcher.initialize();
                }
            }
        });
        if (PipelineType.FLINK_NATIVE_K8S_APPLICATION == pipeline.pipeType()) {
            ((FlinkK8sApplicationBuildPipeline)pipeline.as(FlinkK8sApplicationBuildPipeline.class)).registerDockerProgressWatcher(new DockerProgressWatcher(){

                public void onDockerPullProgressChange(DockerPullSnapshot snapshot) {
                    DOCKER_PULL_PG_SNAPSHOTS.put((Object)app.getId(), (Object)snapshot);
                }

                public void onDockerBuildProgressChange(DockerBuildSnapshot snapshot) {
                    DOCKER_BUILD_PG_SNAPSHOTS.put((Object)app.getId(), (Object)snapshot);
                }

                public void onDockerPushProgressChange(DockerPushSnapshot snapshot) {
                    DOCKER_PUSH_PG_SNAPSHOTS.put((Object)app.getId(), (Object)snapshot);
                }
            });
        }
        AppBuildPipeline buildPipeline = AppBuildPipeline.initFromPipeline(pipeline).setAppId(app.getId());
        boolean saved = this.saveEntity(buildPipeline);
        DOCKER_PULL_PG_SNAPSHOTS.invalidate((Object)app.getId());
        DOCKER_BUILD_PG_SNAPSHOTS.invalidate((Object)app.getId());
        DOCKER_PUSH_PG_SNAPSHOTS.invalidate((Object)app.getId());
        this.buildPipelineExecutor.submit(() -> ((BuildPipeline)pipeline).launch());
        return saved;
    }

    private BuildPipeline createPipelineInstance(@Nonnull Application app) {
        FlinkEnv flinkEnv = this.flinkEnvService.getByIdOrDefault(app.getVersionId());
        String userLocalJar = this.retrieveUserLocalJar(flinkEnv, app);
        ExecutionMode executionMode = app.getExecutionModeEnum();
        String mainClass = app.isCustomCodeJob() ? app.getMainClass() : ConfigConst.STREAMPARK_FLINKSQL_CLIENT_CLASS();
        switch (executionMode) {
            case YARN_APPLICATION: {
                String yarnProvidedPath = app.getAppLib();
                FlinkYarnApplicationBuildRequest yarnAppRequest = new FlinkYarnApplicationBuildRequest(app.getJobName(), mainClass, yarnProvidedPath, app.getDevelopmentMode(), app.getMavenArtifact());
                log.info("Submit params to building pipeline : {}", (Object)yarnAppRequest);
                return FlinkYarnApplicationBuildPipeline.of((FlinkYarnApplicationBuildRequest)yarnAppRequest);
            }
            case YARN_PER_JOB: 
            case YARN_SESSION: 
            case REMOTE: {
                FlinkRemotePerJobBuildRequest buildRequest = new FlinkRemotePerJobBuildRequest(app.getJobName(), app.getLocalAppHome(), mainClass, userLocalJar, app.getExecutionModeEnum(), app.getDevelopmentMode(), flinkEnv.getFlinkVersion(), app.getMavenArtifact());
                log.info("Submit params to building pipeline : {}", (Object)buildRequest);
                return FlinkRemoteBuildPipeline.of((FlinkRemotePerJobBuildRequest)buildRequest);
            }
            case KUBERNETES_NATIVE_SESSION: {
                FlinkCluster flinkCluster = (FlinkCluster)this.flinkClusterService.getById(app.getFlinkClusterId());
                String k8sNamespace = flinkCluster.getK8sNamespace();
                String clusterId = flinkCluster.getClusterId();
                FlinkK8sSessionBuildRequest k8sSessionBuildRequest = new FlinkK8sSessionBuildRequest(app.getJobName(), app.getLocalAppHome(), mainClass, userLocalJar, app.getExecutionModeEnum(), app.getDevelopmentMode(), flinkEnv.getFlinkVersion(), app.getMavenArtifact(), clusterId, k8sNamespace);
                log.info("Submit params to building pipeline : {}", (Object)k8sSessionBuildRequest);
                return FlinkK8sSessionBuildPipeline.of((FlinkK8sSessionBuildRequest)k8sSessionBuildRequest);
            }
            case KUBERNETES_NATIVE_APPLICATION: {
                DockerConfig dockerConfig = DockerConfig.fromSetting();
                FlinkK8sApplicationBuildRequest k8sApplicationBuildRequest = new FlinkK8sApplicationBuildRequest(app.getJobName(), app.getLocalAppHome(), mainClass, userLocalJar, app.getExecutionModeEnum(), app.getDevelopmentMode(), flinkEnv.getFlinkVersion(), app.getMavenArtifact(), app.getJobName(), app.getK8sNamespace(), app.getFlinkImage(), app.getK8sPodTemplates(), app.getK8sHadoopIntegration() != null ? app.getK8sHadoopIntegration() : false, DockerConf.of((String)dockerConfig.getAddress(), (String)dockerConfig.getNamespace(), (String)dockerConfig.getUserName(), (String)dockerConfig.getPassword()), app.getIngressTemplate());
                log.info("Submit params to building pipeline : {}", (Object)k8sApplicationBuildRequest);
                return FlinkK8sApplicationBuildPipeline.of((FlinkK8sApplicationBuildRequest)k8sApplicationBuildRequest);
            }
        }
        throw new UnsupportedOperationException("Unsupported Building Application for ExecutionMode: " + app.getExecutionModeEnum());
    }

    private void prepareJars(Application app) throws IOException {
        File localUploadJar;
        File localUploadDIR = new File(Workspace.local().APP_UPLOADS());
        FileUtils.mkdir((File)localUploadDIR);
        FsOperator localFS = FsOperator.lfs();
        if ((app.isFlinkSqlJob() || app.isCustomCodeJob()) && !app.getMavenDependency().getJar().isEmpty()) {
            for (String jar2 : app.getMavenDependency().getJar()) {
                File localJar = new File(WebUtils.getAppTempDir(), jar2);
                localUploadJar = new File(localUploadDIR, jar2);
                if (!localJar.exists() && !localUploadJar.exists()) {
                    throw new ApiAlertException("Missing file: " + jar2 + ", please upload again");
                }
                if (!localJar.exists()) continue;
                this.checkOrElseUploadJar(localFS, localJar, localUploadJar, localUploadDIR);
            }
        }
        if (app.isCustomCodeJob()) {
            File userJar;
            FsOperator fsOperator = app.getFsOperator();
            ResourceFrom resourceFrom = ResourceFrom.of(app.getResourceFrom());
            if (resourceFrom == ResourceFrom.CICD) {
                userJar = this.getCustomCodeAppDistJar(app);
            } else if (resourceFrom == ResourceFrom.UPLOAD) {
                userJar = new File(WebUtils.getAppTempDir(), app.getJar());
            } else {
                throw new IllegalArgumentException("ResourceFrom error: " + resourceFrom);
            }
            localUploadJar = new File(localUploadDIR, userJar.getName());
            this.checkOrElseUploadJar(localFS, userJar, localUploadJar, localUploadDIR);
            if (app.getExecutionModeEnum() == ExecutionMode.YARN_APPLICATION) {
                String pipelineJar;
                if (!fsOperator.exists(app.getAppHome())) {
                    fsOperator.mkdirs(app.getAppHome());
                }
                if (!fsOperator.exists(pipelineJar = app.getAppHome().concat("/").concat(userJar.getName()))) {
                    fsOperator.upload(localUploadJar.getAbsolutePath(), app.getAppHome());
                } else {
                    InputStream inputStream = Files.newInputStream(localUploadJar.toPath(), new OpenOption[0]);
                    if (!DigestUtils.md5Hex((InputStream)inputStream).equals(fsOperator.fileMd5(pipelineJar))) {
                        fsOperator.upload(localUploadJar.getAbsolutePath(), app.getAppHome());
                    }
                }
                ArrayList dependencyJars = new ArrayList(0);
                app.getMavenDependency().getJar().forEach(jar -> dependencyJars.add(new File(localUploadDIR, (String)jar)));
                if (!app.getMavenDependency().getPom().isEmpty()) {
                    Set artifacts = app.getMavenDependency().getPom().stream().filter(dep -> {
                        File file = new File(localUploadDIR, dep.artifactName());
                        if (file.exists()) {
                            dependencyJars.add(file);
                            return false;
                        }
                        return true;
                    }).map(pom -> new Artifact(pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), pom.getClassifier(), pom.toExclusionString())).collect(Collectors.toSet());
                    Set mavenArts = MavenTool.resolveArtifactsAsJava(artifacts);
                    dependencyJars.addAll(mavenArts);
                }
                String hdfsUploadDIR = Workspace.remote().APP_UPLOADS();
                for (File jarFile : dependencyJars) {
                    String hdfsUploadPath = hdfsUploadDIR + "/" + jarFile.getName();
                    if (!fsOperator.exists(hdfsUploadPath)) {
                        fsOperator.upload(jarFile.getAbsolutePath(), hdfsUploadDIR);
                        continue;
                    }
                    InputStream inputStream = Files.newInputStream(jarFile.toPath(), new OpenOption[0]);
                    if (DigestUtils.md5Hex((InputStream)inputStream).equals(fsOperator.fileMd5(hdfsUploadPath))) continue;
                    fsOperator.upload(jarFile.getAbsolutePath(), hdfsUploadDIR);
                }
                if (!fsOperator.exists(app.getAppLib())) {
                    fsOperator.mkdirs(app.getAppLib());
                } else {
                    fsOperator.mkCleanDirs(app.getAppLib());
                }
                dependencyJars.forEach(jar -> fsOperator.copy(hdfsUploadDIR + "/" + jar.getName(), app.getAppLib()));
            }
        }
    }

    private File getCustomCodeAppDistJar(Application app) {
        switch (app.getApplicationType()) {
            case APACHE_FLINK: {
                return new File(app.getDistHome(), app.getJar());
            }
            case STREAMPARK_FLINK: {
                String userJar = String.format("%s/lib/%s.jar", app.getDistHome(), app.getModule());
                return new File(userJar);
            }
        }
        throw new IllegalArgumentException("[StreamPark] unsupported ApplicationType of custom code: " + app.getApplicationType());
    }

    private String retrieveUserLocalJar(FlinkEnv flinkEnv, Application app) {
        File localUploadDIR = new File(Workspace.local().APP_UPLOADS());
        switch (app.getDevelopmentMode()) {
            case CUSTOM_CODE: {
                switch (app.getApplicationType()) {
                    case STREAMPARK_FLINK: {
                        return String.format("%s/%s", localUploadDIR, app.getModule().concat(".jar"));
                    }
                    case APACHE_FLINK: {
                        return String.format("%s/%s", localUploadDIR, app.getJar());
                    }
                }
                throw new IllegalArgumentException("[StreamPark] unsupported ApplicationType of custom code: " + app.getApplicationType());
            }
            case FLINK_SQL: {
                String sqlDistJar = this.serviceHelper.getSqlClientJar(flinkEnv);
                return Workspace.local().APP_CLIENT().concat("/").concat(sqlDistJar);
            }
        }
        throw new UnsupportedOperationException("[StreamPark] unsupported JobType: " + app.getDevelopmentMode());
    }

    @Override
    public Optional<AppBuildPipeline> getCurrentBuildPipeline(@Nonnull Long appId) {
        return Optional.ofNullable(this.getById(appId));
    }

    @Override
    public DockerResolvedSnapshot getDockerProgressDetailSnapshot(@Nonnull Long appId) {
        return new DockerResolvedSnapshot((DockerPullSnapshot)DOCKER_PULL_PG_SNAPSHOTS.getIfPresent((Object)appId), (DockerBuildSnapshot)DOCKER_BUILD_PG_SNAPSHOTS.getIfPresent((Object)appId), (DockerPushSnapshot)DOCKER_PUSH_PG_SNAPSHOTS.getIfPresent((Object)appId));
    }

    @Override
    public boolean allowToBuildNow(@Nonnull Long appId) {
        return this.getCurrentBuildPipeline(appId).map(pipeline -> PipelineStatus.running != pipeline.getPipelineStatus()).orElse(true);
    }

    @Override
    public Map<Long, PipelineStatus> listPipelineStatus(List<Long> appIds) {
        if (CollectionUtils.isEmpty(appIds)) {
            return Collections.emptyMap();
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(AppBuildPipeline::getAppId, appIds);
        List appBuildPipelines = ((ApplicationBuildPipelineMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)appBuildPipelines)) {
            return Collections.emptyMap();
        }
        return appBuildPipelines.stream().collect(Collectors.toMap(AppBuildPipeline::getAppId, AppBuildPipeline::getPipelineStatus));
    }

    @Override
    public void removeApp(Long appId) {
        ((ApplicationBuildPipelineMapper)this.baseMapper).delete((Wrapper)new LambdaQueryWrapper().eq(AppBuildPipeline::getAppId, (Object)appId));
    }

    public boolean saveEntity(AppBuildPipeline pipe) {
        AppBuildPipeline old = (AppBuildPipeline)this.getById(pipe.getAppId());
        if (old == null) {
            return this.save(pipe);
        }
        return this.updateById(pipe);
    }

    private void checkOrElseUploadJar(FsOperator fsOperator, File localJar, File targetJar, File targetDir) {
        if (!fsOperator.exists(targetJar.getAbsolutePath())) {
            fsOperator.upload(localJar.getAbsolutePath(), targetDir.getAbsolutePath());
        } else if (!FileUtils.equals((File)localJar, (File)targetJar)) {
            fsOperator.upload(localJar.getAbsolutePath(), targetDir.getAbsolutePath());
        }
    }
}

