/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.artifact.resolve.internal;

import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.artifact.resolve.internal.Invoker;
import org.apache.maven.shared.transfer.artifact.resolve.internal.Maven30ArtifactResult;
import org.apache.maven.shared.transfer.artifact.resolve.internal.MavenArtifactResolver;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactDescriptorException;
import org.sonatype.aether.resolution.ArtifactDescriptorRequest;
import org.sonatype.aether.resolution.ArtifactDescriptorResult;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

class Maven30ArtifactResolver
implements MavenArtifactResolver {
    private final RepositorySystem repositorySystem;
    private final List<RemoteRepository> aetherRepositories;
    private final RepositorySystemSession session;

    Maven30ArtifactResolver(RepositorySystem repositorySystem, List<RemoteRepository> aetherRepositories, RepositorySystemSession session) {
        this.repositorySystem = repositorySystem;
        this.aetherRepositories = aetherRepositories;
        this.session = session;
    }

    @Override
    public ArtifactResult resolveArtifact(org.apache.maven.artifact.Artifact mavenArtifact) throws ArtifactResolverException {
        Artifact aetherArtifact = (Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", org.apache.maven.artifact.Artifact.class, (Object)mavenArtifact);
        return this.resolveArtifact(aetherArtifact);
    }

    @Override
    public ArtifactResult resolveArtifact(ArtifactCoordinate coordinate) throws ArtifactResolverException {
        DefaultArtifact aetherArtifact = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), coordinate.getExtension(), coordinate.getVersion());
        return this.resolveArtifact((Artifact)aetherArtifact);
    }

    private ArtifactResult resolveArtifact(Artifact aetherArtifact) throws ArtifactResolverException {
        try {
            ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest(aetherArtifact, this.aetherRepositories, null);
            ArtifactDescriptorResult descriptorResult = this.repositorySystem.readArtifactDescriptor(this.session, descriptorRequest);
            ArtifactRequest request = new ArtifactRequest(descriptorResult.getArtifact(), this.aetherRepositories, null);
            return new Maven30ArtifactResult(this.repositorySystem.resolveArtifact(this.session, request));
        }
        catch (ArtifactDescriptorException e) {
            throw new ArtifactResolverException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new ArtifactResolverException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

