/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public class SimpleVersionedListState<T>
implements ListState<T> {
    private final ListState<byte[]> rawState;
    private final SimpleVersionedSerializer<T> serializer;

    public SimpleVersionedListState(ListState<byte[]> rawState, SimpleVersionedSerializer<T> serializer) {
        this.rawState = (ListState)Preconditions.checkNotNull(rawState);
        this.serializer = (SimpleVersionedSerializer)Preconditions.checkNotNull(serializer);
    }

    public void update(@Nullable List<T> values) throws Exception {
        this.rawState.update(this.serializeAll(values));
    }

    public void addAll(@Nullable List<T> values) throws Exception {
        this.rawState.addAll(this.serializeAll(values));
    }

    public Iterable<T> get() throws Exception {
        Iterable rawIterable = (Iterable)this.rawState.get();
        SimpleVersionedSerializer serializer = this.serializer;
        return () -> new DeserializingIterator(rawIterable.iterator(), serializer);
    }

    public void add(T value) throws Exception {
        this.rawState.add((Object)this.serialize(value));
    }

    public void clear() {
        this.rawState.clear();
    }

    private byte[] serialize(T value) throws IOException {
        return SimpleVersionedSerialization.writeVersionAndSerialize(this.serializer, value);
    }

    @Nullable
    private List<byte[]> serializeAll(@Nullable List<T> values) throws IOException {
        if (values == null) {
            return null;
        }
        ArrayList<byte[]> rawValues = new ArrayList<byte[]>(values.size());
        for (T value : values) {
            rawValues.add(this.serialize(value));
        }
        return rawValues;
    }

    private static final class DeserializingIterator<T>
    implements Iterator<T> {
        private final Iterator<byte[]> rawIterator;
        private final SimpleVersionedSerializer<T> serializer;

        private DeserializingIterator(Iterator<byte[]> rawIterator, SimpleVersionedSerializer<T> serializer) {
            this.rawIterator = rawIterator;
            this.serializer = serializer;
        }

        @Override
        public boolean hasNext() {
            return this.rawIterator.hasNext();
        }

        @Override
        public T next() {
            byte[] bytes = this.rawIterator.next();
            try {
                return (T)SimpleVersionedSerialization.readVersionAndDeSerialize(this.serializer, (byte[])bytes);
            }
            catch (IOException e) {
                throw new FlinkRuntimeException("Failed to deserialize value", (Throwable)e);
            }
        }
    }
}

