/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractAggregatingMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedJobMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedJobMetricsParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.JobsFilterQueryParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class AggregatingJobsMetricsHandler
extends AbstractAggregatingMetricsHandler<AggregatedJobMetricsParameters> {
    public AggregatingJobsMetricsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, Executor executor, MetricFetcher fetcher) {
        super(leaderRetriever, timeout, responseHeaders, AggregatedJobMetricsHeaders.getInstance(), executor, fetcher);
    }

    @Override
    @Nonnull
    Collection<? extends MetricStore.ComponentMetricStore> getStores(MetricStore store, HandlerRequest<EmptyRequestBody, AggregatedJobMetricsParameters> request) {
        List jobs = request.getQueryParameter(JobsFilterQueryParameter.class);
        if (jobs.isEmpty()) {
            return store.getJobs().values();
        }
        ArrayList<MetricStore.ComponentMetricStore> jobStores = new ArrayList<MetricStore.ComponentMetricStore>(jobs.size());
        for (JobID job : jobs) {
            MetricStore.ComponentMetricStore jobMetricStore = store.getJobMetricStore(job.toString());
            if (jobMetricStore == null) continue;
            jobStores.add(jobMetricStore);
        }
        return jobStores;
    }
}

