/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class ConnectionID
implements Serializable {
    private static final long serialVersionUID = -8068626194818666857L;
    private final InetSocketAddress address;
    private final int connectionIndex;

    public ConnectionID(TaskManagerLocation connectionInfo, int connectionIndex) {
        this(new InetSocketAddress(connectionInfo.address(), connectionInfo.dataPort()), connectionIndex);
    }

    public ConnectionID(InetSocketAddress address, int connectionIndex) {
        this.address = (InetSocketAddress)Preconditions.checkNotNull((Object)address);
        Preconditions.checkArgument((connectionIndex >= 0 ? 1 : 0) != 0);
        this.connectionIndex = connectionIndex;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getConnectionIndex() {
        return this.connectionIndex;
    }

    public int hashCode() {
        return this.address.hashCode() + 31 * this.connectionIndex;
    }

    public boolean equals(Object other) {
        if (other.getClass() != ConnectionID.class) {
            return false;
        }
        ConnectionID ra = (ConnectionID)other;
        return ra.getAddress().equals(this.address) && ra.getConnectionIndex() == this.connectionIndex;
    }

    public String toString() {
        return this.address + " [" + this.connectionIndex + "]";
    }
}

