/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.streampark.common.util.DateUtils;

public final class JacksonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JacksonUtils() {
    }

    public static <T> T read(String json, Class<T> clazz) throws JsonProcessingException {
        return (T)MAPPER.readValue(json, clazz);
    }

    public static <T> T read(String json, TypeReference<T> typeReference) throws JsonProcessingException {
        return (T)MAPPER.readValue(json, typeReference);
    }

    public static String write(Object object) throws JsonProcessingException {
        return MAPPER.writeValueAsString(object);
    }

    static {
        MAPPER.registerModule((Module)new DefaultScalaModule());
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat(DateUtils.fullFormat()));
    }
}

