/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.CollectionSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.ArrayListSerializerSnapshot;

public final class ArrayListSerializer<T>
extends TypeSerializer<ArrayList<T>>
implements TypeSerializerConfigSnapshot.SelfResolvingTypeSerializer<ArrayList<T>> {
    private static final long serialVersionUID = 1119562170939152304L;
    private final TypeSerializer<T> elementSerializer;

    public ArrayListSerializer(TypeSerializer<T> elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    public TypeSerializer<T> getElementSerializer() {
        return this.elementSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<ArrayList<T>> duplicate() {
        TypeSerializer duplicateElement = this.elementSerializer.duplicate();
        return duplicateElement == this.elementSerializer ? this : new ArrayListSerializer<T>(duplicateElement);
    }

    public ArrayList<T> createInstance() {
        return new ArrayList();
    }

    public ArrayList<T> copy(ArrayList<T> from) {
        if (this.elementSerializer.isImmutableType()) {
            return new ArrayList<T>(from);
        }
        ArrayList<Object> newList = new ArrayList<Object>(from.size());
        for (int i = 0; i < from.size(); ++i) {
            newList.add(this.elementSerializer.copy(from.get(i)));
        }
        return newList;
    }

    public ArrayList<T> copy(ArrayList<T> from, ArrayList<T> reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(ArrayList<T> list, DataOutputView target) throws IOException {
        int size = list.size();
        target.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.elementSerializer.serialize(list.get(i), target);
        }
    }

    public ArrayList<T> deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.elementSerializer.deserialize(source));
        }
        return list;
    }

    public ArrayList<T> deserialize(ArrayList<T> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int num = source.readInt();
        target.writeInt(num);
        for (int i = 0; i < num; ++i) {
            this.elementSerializer.copy(source, target);
        }
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && this.elementSerializer.equals(((ArrayListSerializer)((Object)obj)).elementSerializer);
    }

    public int hashCode() {
        return this.elementSerializer.hashCode();
    }

    public TypeSerializerSnapshot<ArrayList<T>> snapshotConfiguration() {
        return new ArrayListSerializerSnapshot(this);
    }

    public TypeSerializerSchemaCompatibility<ArrayList<T>> resolveSchemaCompatibilityViaRedirectingToNewSnapshotClass(TypeSerializerConfigSnapshot<ArrayList<T>> deprecatedConfigSnapshot) {
        if (deprecatedConfigSnapshot instanceof CollectionSerializerConfigSnapshot) {
            CollectionSerializerConfigSnapshot castedLegacySnapshot = (CollectionSerializerConfigSnapshot)deprecatedConfigSnapshot;
            ArrayListSerializerSnapshot newSnapshot = new ArrayListSerializerSnapshot();
            return CompositeTypeSerializerUtil.delegateCompatibilityCheckToNewSnapshot((TypeSerializer)this, newSnapshot, (TypeSerializerSnapshot[])castedLegacySnapshot.getNestedSerializerSnapshots());
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }
}

