/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.streampark.common.fs.FsOperator;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ApplicationBackUp;
import org.apache.streampark.console.core.entity.ApplicationConfig;
import org.apache.streampark.console.core.entity.FlinkSql;
import org.apache.streampark.console.core.enums.EffectiveType;
import org.apache.streampark.console.core.enums.ReleaseState;
import org.apache.streampark.console.core.mapper.ApplicationBackUpMapper;
import org.apache.streampark.console.core.service.ApplicationBackUpService;
import org.apache.streampark.console.core.service.ApplicationConfigService;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.EffectiveService;
import org.apache.streampark.console.core.service.FlinkSqlService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class ApplicationBackUpServiceImpl
extends ServiceImpl<ApplicationBackUpMapper, ApplicationBackUp>
implements ApplicationBackUpService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationBackUpServiceImpl.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationConfigService configService;
    @Autowired
    private EffectiveService effectiveService;
    @Autowired
    private FlinkSqlService flinkSqlService;

    @Override
    public IPage<ApplicationBackUp> page(ApplicationBackUp backUp, RestRequest request) {
        Page page = MybatisPager.getPage(request);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApplicationBackUp::getAppId, (Object)backUp.getAppId());
        return ((ApplicationBackUpMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rollback(ApplicationBackUp backParam) {
        Application application = (Application)this.applicationService.getById(backParam.getAppId());
        FsOperator fsOperator = application.getFsOperator();
        if (!fsOperator.exists(backParam.getPath())) {
            return;
        }
        if (backParam.isBackup()) {
            application.setBackUpDescription(backParam.getDescription());
            if (application.isFlinkSqlJob()) {
                FlinkSql flinkSql = this.flinkSqlService.getEffective(application.getId(), false);
                this.backup(application, flinkSql);
            } else {
                this.backup(application, null);
            }
        }
        if (application.isRunning()) {
            this.configService.setLatestOrEffective(true, backParam.getId(), backParam.getAppId());
        } else {
            this.effectiveService.saveOrUpdate(backParam.getAppId(), EffectiveType.CONFIG, backParam.getId());
            if (application.isFlinkSqlJob()) {
                this.effectiveService.saveOrUpdate(backParam.getAppId(), EffectiveType.FLINKSQL, backParam.getSqlId());
            }
        }
        fsOperator.delete(application.getAppHome());
        fsOperator.copyDir(backParam.getPath(), application.getAppHome());
        this.applicationService.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(Application::getId, (Object)application.getId())).set(Application::getRelease, (Object)ReleaseState.NEED_RESTART.get()));
    }

    @Override
    public void revoke(Application application) {
        Page page = new Page();
        page.setCurrent(0L).setSize(1L).setSearchCount(false);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApplicationBackUp::getAppId, (Object)application.getId())).orderByDesc(ApplicationBackUp::getCreateTime);
        Page backUpPages = (Page)((ApplicationBackUpMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)queryWrapper);
        if (!backUpPages.getRecords().isEmpty()) {
            ApplicationBackUp backup = (ApplicationBackUp)backUpPages.getRecords().get(0);
            String path = backup.getPath();
            application.getFsOperator().move(path, application.getWorkspace().APP_WORKSPACE());
            this.removeById(backup.getId());
        }
    }

    @Override
    public void removeApp(Application application) {
        try {
            ((ApplicationBackUpMapper)this.baseMapper).delete((Wrapper)new LambdaQueryWrapper().eq(ApplicationBackUp::getAppId, (Object)application.getId()));
            application.getFsOperator().delete(application.getWorkspace().APP_BACKUPS().concat("/").concat(application.getId().toString()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void rollbackFlinkSql(Application application, FlinkSql sql) {
        ApplicationBackUp backUp = this.getFlinkSqlBackup(application.getId(), sql.getId());
        ApiAlertException.throwIfNull(backUp, "Application backup can't be null. Rollback flink sql failed.");
        this.effectiveService.saveOrUpdate(backUp.getAppId(), EffectiveType.CONFIG, backUp.getId());
        this.effectiveService.saveOrUpdate(backUp.getAppId(), EffectiveType.FLINKSQL, backUp.getSqlId());
    }

    @Override
    public boolean isFlinkSqlBacked(Long appId, Long sqlId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApplicationBackUp::getAppId, (Object)appId)).eq(ApplicationBackUp::getSqlId, (Object)sqlId);
        return ((ApplicationBackUpMapper)this.baseMapper).selectCount((Wrapper)queryWrapper) > 0L;
    }

    private ApplicationBackUp getFlinkSqlBackup(Long appId, Long sqlId) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApplicationBackUp::getAppId, (Object)appId)).eq(ApplicationBackUp::getSqlId, (Object)sqlId);
        return (ApplicationBackUp)((ApplicationBackUpMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    @Override
    public Boolean delete(Long id) throws InternalException {
        ApplicationBackUp backUp = (ApplicationBackUp)this.getById(id);
        try {
            Application application = (Application)this.applicationService.getById(backUp.getAppId());
            application.getFsOperator().delete(backUp.getPath());
            this.removeById(id);
            return true;
        }
        catch (Exception e) {
            throw new InternalException(e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void backup(Application application, FlinkSql flinkSql) {
        String appHome = application.isCustomCodeJob() && application.isCICDJob() ? application.getDistHome() : application.getAppHome();
        FsOperator fsOperator = application.getFsOperator();
        if (fsOperator.exists(appHome)) {
            ApplicationConfig config = this.configService.getEffective(application.getId());
            if (config != null) {
                application.setConfigId(config.getId());
            }
            int version = 1;
            if (flinkSql != null) {
                application.setSqlId(flinkSql.getId());
                version = flinkSql.getVersion();
            } else if (config != null) {
                version = config.getVersion();
            }
            ApplicationBackUp applicationBackUp = new ApplicationBackUp(application);
            applicationBackUp.setVersion(version);
            this.save(applicationBackUp);
            fsOperator.mkdirs(applicationBackUp.getPath());
            fsOperator.copyDir(appHome, applicationBackUp.getPath());
        }
    }
}

