/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.bean;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.streampark.console.core.entity.Setting;

public class SettingAlertEmailConfigParams {
    private Setting host;
    private Setting port;
    private Setting from;
    private Setting username;
    private Setting password;
    private Setting ssl;
    private static final String EMAIL_ADDRESS_REGEXP = "^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$";
    private static final String PORT_REGEXP = "^([1-9]\\d{0,3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5])$";
    private static final String FROM_REGEXP = "";
    private static final String USER_NAME_REGEXP = "^[a-zA-Z][a-zA-Z0-9_]{4,15}$";
    private static final String PASS_WORD_REGEXP = "^[a-zA-Z][a-zA-Z0-9_]{4,15}$";
    private static final String SSL_REGEXP = "^(true|false)$";

    public static boolean verifyParams(SettingAlertEmailConfigParams params) {
        return params.verifyHost() && params.verifyPort() && params.verifyFrom() && params.verifyUserName() && params.verifyPassWord() && params.verifySSL();
    }

    private boolean verifyHost() {
        if (Objects.isNull(this.getHost()) || Objects.isNull(this.getHost().getSettingValue())) {
            return false;
        }
        return Pattern.matches(EMAIL_ADDRESS_REGEXP, this.getHost().getSettingValue());
    }

    private boolean verifyPort() {
        if (Objects.isNull(this.getPort()) || Objects.isNull(this.getPort().getSettingValue())) {
            return false;
        }
        return Pattern.matches(PORT_REGEXP, this.getPort().getSettingValue());
    }

    private boolean verifyFrom() {
        if (Objects.isNull(this.getFrom()) || Objects.isNull(this.getFrom().getSettingValue())) {
            return false;
        }
        return Pattern.matches(FROM_REGEXP, this.getFrom().getSettingValue());
    }

    private boolean verifyUserName() {
        if (Objects.isNull(this.getUsername()) || Objects.isNull(this.getUsername().getSettingValue())) {
            return false;
        }
        return Pattern.matches("^[a-zA-Z][a-zA-Z0-9_]{4,15}$", this.getUsername().getSettingValue());
    }

    private boolean verifyPassWord() {
        if (Objects.isNull(this.getPassword()) || Objects.isNull(this.getPassword().getSettingValue())) {
            return false;
        }
        return Pattern.matches("^[a-zA-Z][a-zA-Z0-9_]{4,15}$", this.getPassword().getSettingValue());
    }

    private boolean verifySSL() {
        if (Objects.isNull(this.getSsl()) || Objects.isNull(this.getSsl().getSettingValue())) {
            return false;
        }
        return Pattern.matches(SSL_REGEXP, this.getSsl().getSettingValue());
    }

    public Setting getHost() {
        return this.host;
    }

    public Setting getPort() {
        return this.port;
    }

    public Setting getFrom() {
        return this.from;
    }

    public Setting getUsername() {
        return this.username;
    }

    public Setting getPassword() {
        return this.password;
    }

    public Setting getSsl() {
        return this.ssl;
    }

    public void setHost(Setting host) {
        this.host = host;
    }

    public void setPort(Setting port) {
        this.port = port;
    }

    public void setFrom(Setting from) {
        this.from = from;
    }

    public void setUsername(Setting username) {
        this.username = username;
    }

    public void setPassword(Setting password) {
        this.password = password;
    }

    public void setSsl(Setting ssl) {
        this.ssl = ssl;
    }
}

