/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.bean;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.console.base.util.JacksonUtils;
import org.apache.streampark.console.core.bean.AlertDingTalkParams;
import org.apache.streampark.console.core.bean.AlertEmailParams;
import org.apache.streampark.console.core.bean.AlertHttpCallbackParams;
import org.apache.streampark.console.core.bean.AlertLarkParams;
import org.apache.streampark.console.core.bean.AlertWeComParams;
import org.apache.streampark.console.core.entity.AlertConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@Schema(name="AlertConfig")
public class AlertConfigWithParams
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AlertConfigWithParams.class);
    @Schema(example="1")
    private Long id;
    @Schema(example="100000")
    private Long userId;
    @Schema(example="test-alert")
    private String alertName;
    @Schema(example="1", description="base type, email 1, dink-talk 2, we-com 4, http callback 8, lark 16, also choose a combination, e.g. 3 means email + dink-talk")
    private Integer alertType;
    @Schema(description="email alert parameters")
    private AlertEmailParams emailParams;
    @Schema(description="ding-talk alert parameters")
    private AlertDingTalkParams dingTalkParams;
    @Schema(description="we-com alert parameters")
    private AlertWeComParams weComParams;
    @Schema(description="http callback alert parameters")
    private AlertHttpCallbackParams httpCallbackParams;
    @Schema(description="lark alert parameters")
    private AlertLarkParams larkParams;

    public static AlertConfigWithParams of(AlertConfig config) {
        if (config == null) {
            return null;
        }
        AlertConfigWithParams params = new AlertConfigWithParams();
        BeanUtils.copyProperties((Object)config, (Object)params, (String[])new String[]{"emailParams", "dingTalkParams", "weComParams", "httpCallbackParams", "larkParams"});
        try {
            if (StringUtils.isNotBlank((CharSequence)config.getEmailParams())) {
                params.setEmailParams(JacksonUtils.read(config.getEmailParams(), AlertEmailParams.class));
            }
            if (StringUtils.isNotBlank((CharSequence)config.getDingTalkParams())) {
                params.setDingTalkParams(JacksonUtils.read(config.getDingTalkParams(), AlertDingTalkParams.class));
            }
            if (StringUtils.isNotBlank((CharSequence)config.getWeComParams())) {
                params.setWeComParams(JacksonUtils.read(config.getWeComParams(), AlertWeComParams.class));
            }
            if (StringUtils.isNotBlank((CharSequence)config.getHttpCallbackParams())) {
                params.setHttpCallbackParams(JacksonUtils.read(config.getHttpCallbackParams(), AlertHttpCallbackParams.class));
            }
            if (StringUtils.isNotBlank((CharSequence)config.getLarkParams())) {
                params.setLarkParams(JacksonUtils.read(config.getLarkParams(), AlertLarkParams.class));
            }
        }
        catch (JsonProcessingException e) {
            log.error("Json read failed", (Throwable)e);
        }
        return params;
    }

    public Long getId() {
        return this.id;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getAlertName() {
        return this.alertName;
    }

    public Integer getAlertType() {
        return this.alertType;
    }

    public AlertEmailParams getEmailParams() {
        return this.emailParams;
    }

    public AlertDingTalkParams getDingTalkParams() {
        return this.dingTalkParams;
    }

    public AlertWeComParams getWeComParams() {
        return this.weComParams;
    }

    public AlertHttpCallbackParams getHttpCallbackParams() {
        return this.httpCallbackParams;
    }

    public AlertLarkParams getLarkParams() {
        return this.larkParams;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setAlertName(String alertName) {
        this.alertName = alertName;
    }

    public void setAlertType(Integer alertType) {
        this.alertType = alertType;
    }

    public void setEmailParams(AlertEmailParams emailParams) {
        this.emailParams = emailParams;
    }

    public void setDingTalkParams(AlertDingTalkParams dingTalkParams) {
        this.dingTalkParams = dingTalkParams;
    }

    public void setWeComParams(AlertWeComParams weComParams) {
        this.weComParams = weComParams;
    }

    public void setHttpCallbackParams(AlertHttpCallbackParams httpCallbackParams) {
        this.httpCallbackParams = httpCallbackParams;
    }

    public void setLarkParams(AlertLarkParams larkParams) {
        this.larkParams = larkParams;
    }
}

