/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.util;

import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;

public final class CommonUtils
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static final long serialVersionUID = 1L;
    private static final String OS = System.getProperty("os.name").toLowerCase();

    private CommonUtils() {
    }

    public static Boolean isEmpty(Object ... objs) {
        if (objs == null) {
            return Boolean.TRUE;
        }
        if (objs.length == 0) {
            return Boolean.TRUE;
        }
        for (Object obj : objs) {
            if (obj == null) {
                return true;
            }
            if (obj instanceof CharSequence && "".equals(obj.toString().trim())) {
                return true;
            }
            if (obj instanceof Collection && ((Collection)obj).isEmpty()) {
                return true;
            }
            if (obj instanceof Map && ((Map)obj).isEmpty()) {
                return true;
            }
            if (obj instanceof Iterable && (((Iterable)obj).iterator() == null || !((Iterable)obj).iterator().hasNext())) {
                return true;
            }
            if (obj instanceof Iterator && !((Iterator)obj).hasNext()) {
                return true;
            }
            if (obj instanceof File && !((File)obj).exists()) {
                return true;
            }
            if (!(obj instanceof Object[]) || ((Object[])obj).length != 0) continue;
            return true;
        }
        return false;
    }

    public static Boolean notEmpty(Object ... obj) {
        return CommonUtils.isEmpty(obj) == false;
    }

    public static Long toLong(Object val, Long defVal) {
        if (CommonUtils.isEmpty(val).booleanValue()) {
            return defVal;
        }
        try {
            return Long.parseLong(val.toString());
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static Long toLong(Object val) {
        return CommonUtils.toLong(val, null);
    }

    public static Integer toInt(Object val, Integer defVal) {
        if (CommonUtils.isEmpty(val).booleanValue()) {
            return defVal;
        }
        try {
            return Integer.parseInt(val.toString());
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static float toFloat(Object val, float defVal) {
        if (CommonUtils.isEmpty(val).booleanValue()) {
            return defVal;
        }
        try {
            return Float.parseFloat(val.toString());
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static Boolean toBoolean(String text, Boolean defVal) {
        if (CommonUtils.isEmpty(text).booleanValue()) {
            return false;
        }
        try {
            return Boolean.parseBoolean(text);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static Boolean toBoolean(String text) {
        return CommonUtils.toBoolean(text, false);
    }

    public static Integer toInt(Object val) {
        return CommonUtils.toInt(val, null);
    }

    public static Float toFloat(Object val) {
        return Float.valueOf(CommonUtils.toFloat(val, 0.0f));
    }

    public static List arrayToList(Object source) {
        return Arrays.asList(ObjectUtils.toObjectArray(source));
    }

    public static boolean contains(Iterator iterator, Object element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (!ObjectUtils.safeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enumeration enumeration, Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!ObjectUtils.safeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean deleteFile(File dir) {
        if (!dir.exists()) {
            return false;
        }
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (CommonUtils.deleteFile(file)) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean containsInstance(Collection collection, Object element) {
        if (collection != null) {
            for (Object candidate : collection) {
                if (candidate != element) continue;
                return true;
            }
        }
        return false;
    }

    public static <A, E extends A> A[] toArray(Enumeration<E> enumeration, A[] array) {
        ArrayList<E> elements = new ArrayList<E>();
        while (enumeration.hasMoreElements()) {
            elements.add(enumeration.nextElement());
        }
        return elements.toArray(array);
    }

    public static <E> Iterator<E> toIterator(Enumeration<E> enumeration) {
        class EnumerationIterator<E>
        implements Iterator<E> {
            private final Enumeration<E> enumeration;

            public EnumerationIterator(Enumeration<E> enumeration) {
                this.enumeration = enumeration;
            }

            @Override
            public boolean hasNext() {
                return this.enumeration.hasMoreElements();
            }

            @Override
            public E next() {
                return this.enumeration.nextElement();
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException("Not supported");
            }
        }
        return new EnumerationIterator<E>(enumeration);
    }

    public static String getOsName() {
        return OS;
    }

    public static boolean isLinux() {
        return OS.indexOf("linux") >= 0;
    }

    public static boolean isMacOS() {
        return OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0 && OS.indexOf("x") < 0;
    }

    public static boolean isMacOSX() {
        return OS.indexOf("mac") >= 0 && OS.indexOf("os") > 0 && OS.indexOf("x") > 0;
    }

    public static boolean isWindows() {
        return OS.indexOf("windows") >= 0;
    }

    public static boolean isOS2() {
        return OS.indexOf("os/2") >= 0;
    }

    public static boolean isSolaris() {
        return OS.indexOf("solaris") >= 0;
    }

    public static boolean isSunOS() {
        return OS.indexOf("sunos") >= 0;
    }

    public static boolean isMPEiX() {
        return OS.indexOf("mpe/ix") >= 0;
    }

    public static boolean isHPUX() {
        return OS.indexOf("hp-ux") >= 0;
    }

    public static boolean isAix() {
        return OS.indexOf("aix") >= 0;
    }

    public static boolean isOS390() {
        return OS.indexOf("os/390") >= 0;
    }

    public static boolean isFreeBSD() {
        return OS.indexOf("freebsd") >= 0;
    }

    public static boolean isIrix() {
        return OS.indexOf("irix") >= 0;
    }

    public static boolean isDigitalUnix() {
        return OS.indexOf("digital") >= 0 && OS.indexOf("unix") > 0;
    }

    public static boolean isNetWare() {
        return OS.indexOf("netware") >= 0;
    }

    public static boolean isOSF1() {
        return OS.indexOf("osf1") >= 0;
    }

    public static boolean isOpenVMS() {
        return OS.indexOf("openvms") >= 0;
    }

    public static boolean isUnix() {
        boolean isUnix = CommonUtils.isLinux();
        if (!isUnix) {
            isUnix = CommonUtils.isMacOS();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isMacOSX();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isLinux();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isDigitalUnix();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isAix();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isFreeBSD();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isHPUX();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isIrix();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isMPEiX();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isNetWare();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isOpenVMS();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isOS2();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isOS390();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isOSF1();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isSunOS();
        }
        if (!isUnix) {
            isUnix = CommonUtils.isSolaris();
        }
        return isUnix;
    }

    public static int getPlatform() {
        int platform = 0;
        if (CommonUtils.isUnix()) {
            platform = 1;
        }
        if (CommonUtils.isWindows()) {
            platform = 2;
        }
        return platform;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortMapByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, Comparator.comparing(Map.Entry::getValue));
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <T> T[] arrayRemoveElements(T[] array, T ... elem) {
        Utils.notNull(array);
        ArrayList arrayList = new ArrayList(0);
        Collections.addAll(arrayList, array);
        if (CommonUtils.isEmpty(elem).booleanValue()) {
            return array;
        }
        for (T el : elem) {
            arrayList.remove(el);
        }
        return Arrays.copyOf(arrayList.toArray(array), arrayList.size());
    }

    public static <T> T[] arrayRemoveIndex(T[] array, int ... index) {
        Utils.notNull(array);
        for (int j : index) {
            if (j >= 0 && j <= array.length - 1) continue;
            throw new IndexOutOfBoundsException("index error.@" + j);
        }
        ArrayList arrayList = new ArrayList(0);
        Collections.addAll(arrayList, array);
        int i = 0;
        for (int j : index) {
            arrayList.remove(j - i);
            ++i;
        }
        return Arrays.copyOf(arrayList.toArray(array), arrayList.size());
    }

    public static <T> T[] arrayInsertIndex(T[] array, int index, T t) {
        Utils.notNull(array);
        ArrayList<T> arrayList = new ArrayList<T>(array.length + 1);
        if (index == 0) {
            arrayList.add(t);
            Collections.addAll(arrayList, array);
        } else {
            T[] before = Arrays.copyOfRange(array, 0, index);
            T[] after = Arrays.copyOfRange(array, index, array.length);
            Collections.addAll(arrayList, before);
            arrayList.add(t);
            Collections.addAll(arrayList, after);
        }
        return arrayList.toArray(array);
    }

    public static String uuid() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String uuid(int len) {
        StringBuffer sb = new StringBuffer();
        while (sb.length() < len) {
            sb.append(CommonUtils.uuid());
        }
        return sb.substring(0, len);
    }

    public static Double fixedNum(Number number) {
        return CommonUtils.fixedNum(number, 2);
    }

    public static Double fixedNum(Number number, int offset) {
        if (number.doubleValue() == 0.0) {
            return 0.0;
        }
        String prefix = "";
        while (offset > 0) {
            prefix = prefix + "0";
            --offset;
        }
        DecimalFormat df = new DecimalFormat("#." + prefix);
        try {
            return Double.parseDouble(df.format(number));
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0.0;
        }
    }

    public static String toPercent(Number number) {
        return CommonUtils.toPercent(number, 0);
    }

    public static String toPercent(Number number, int offset) {
        Double num = CommonUtils.fixedNum(number, offset += 2);
        return num * 100.0 + "%";
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(String.valueOf(key), beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> T mapToBean(Map<String, Object> map, T bean) {
        BeanMap beanMap = BeanMap.create(bean);
        beanMap.putAll(map);
        return bean;
    }

    public static <T> List<Map<String, Object>> objectsToMaps(List<T> objList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (objList != null && !objList.isEmpty()) {
            Map<String, Object> map = null;
            T bean = null;
            for (T t : objList) {
                bean = t;
                map = CommonUtils.beanToMap(bean);
                list.add(map);
            }
        }
        return list;
    }

    public static <T> List<T> mapsToObjects(List<Map<String, Object>> maps, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        ArrayList<T> list = new ArrayList<T>();
        if (maps != null && !maps.isEmpty()) {
            Iterator<Map<String, Object>> iterator = maps.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> stringObjectMap;
                Map<String, Object> map = stringObjectMap = iterator.next();
                T bean = clazz.newInstance();
                CommonUtils.mapToBean(map, bean);
                list.add(bean);
            }
        }
        return list;
    }

    public static Integer getPid() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        try {
            return Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static boolean isLegalUrl(String url) {
        try {
            new URI(url);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

