/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Base64;
import java.util.Date;
import org.apache.streampark.common.util.DeflaterUtils;
import org.apache.streampark.console.core.bean.MavenDependency;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.enums.ChangedType;

@TableName(value="t_flink_sql")
public class FlinkSql {
    @TableId(type=IdType.AUTO)
    private Long id;
    private Long appId;
    @TableField(value="`sql`")
    private String sql;
    private String dependency;
    private Integer version = 1;
    private Integer candidate;
    private Date createTime;
    private transient boolean effective = false;
    private transient boolean sqlDifference = false;
    private transient boolean dependencyDifference = false;

    public FlinkSql() {
    }

    public FlinkSql(Application application) {
        this.appId = application.getId();
        this.sql = application.getFlinkSql();
        this.dependency = application.getDependency();
        this.createTime = new Date();
    }

    public void decode() {
        this.setSql(DeflaterUtils.unzipString((String)this.sql));
    }

    public void setToApplication(Application application) {
        String encode = Base64.getEncoder().encodeToString(this.sql.getBytes());
        application.setFlinkSql(encode);
        application.setDependency(this.dependency);
        application.setSqlId(this.id);
    }

    public ChangedType checkChange(FlinkSql target) {
        boolean depDifference;
        boolean sqlDifference = !this.getSql().trim().equals(target.getSql().trim());
        MavenDependency thisDependency = MavenDependency.of(this.getDependency());
        MavenDependency targetDependency = MavenDependency.of(target.getDependency());
        boolean bl = depDifference = !thisDependency.equals(targetDependency);
        if (sqlDifference && depDifference) {
            return ChangedType.ALL;
        }
        if (sqlDifference) {
            return ChangedType.SQL;
        }
        if (depDifference) {
            return ChangedType.DEPENDENCY;
        }
        return ChangedType.NONE;
    }

    public void base64Encode() {
        this.sql = Base64.getEncoder().encodeToString(DeflaterUtils.unzipString((String)this.sql).getBytes());
    }

    public Long getId() {
        return this.id;
    }

    public Long getAppId() {
        return this.appId;
    }

    public String getSql() {
        return this.sql;
    }

    public String getDependency() {
        return this.dependency;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Integer getCandidate() {
        return this.candidate;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public boolean isEffective() {
        return this.effective;
    }

    public boolean isSqlDifference() {
        return this.sqlDifference;
    }

    public boolean isDependencyDifference() {
        return this.dependencyDifference;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setDependency(String dependency) {
        this.dependency = dependency;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setCandidate(Integer candidate) {
        this.candidate = candidate;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setEffective(boolean effective) {
        this.effective = effective;
    }

    public void setSqlDifference(boolean sqlDifference) {
        this.sqlDifference = sqlDifference;
    }

    public void setDependencyDifference(boolean dependencyDifference) {
        this.dependencyDifference = dependencyDifference;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlinkSql)) {
            return false;
        }
        FlinkSql other = (FlinkSql)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$appId = this.getAppId();
        Long other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Integer this$candidate = this.getCandidate();
        Integer other$candidate = other.getCandidate();
        if (this$candidate == null ? other$candidate != null : !((Object)this$candidate).equals(other$candidate)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$dependency = this.getDependency();
        String other$dependency = other.getDependency();
        if (this$dependency == null ? other$dependency != null : !this$dependency.equals(other$dependency)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlinkSql;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Integer $candidate = this.getCandidate();
        result = result * 59 + ($candidate == null ? 43 : ((Object)$candidate).hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $dependency = this.getDependency();
        result = result * 59 + ($dependency == null ? 43 : $dependency.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "FlinkSql(id=" + this.getId() + ", appId=" + this.getAppId() + ", sql=" + this.getSql() + ", dependency=" + this.getDependency() + ", version=" + this.getVersion() + ", candidate=" + this.getCandidate() + ", createTime=" + this.getCreateTime() + ", effective=" + this.isEffective() + ", sqlDifference=" + this.isSqlDifference() + ", dependencyDifference=" + this.isDependencyDifference() + ")";
    }
}

