/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.helper;

import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.Prettyable;
import io.fabric8.kubernetes.client.dsl.Terminateable;
import java.io.File;
import java.nio.charset.Charset;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.SystemPropertyUtils$;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.apache.streampark.flink.kubernetes.helper.KubernetesDeploymentHelper$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KubernetesDeploymentHelper$
implements Logger {
    public static final KubernetesDeploymentHelper$ MODULE$;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new KubernetesDeploymentHelper$();
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public String logName() {
        return Logger.class.logName((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.class.logger((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.class.logInfo((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.class.logInfo((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.class.logDebug((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.class.logDebug((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.class.logTrace((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.class.logTrace((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.class.logWarn((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.class.logWarn((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.class.logError((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.class.logError((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.class.isTraceEnabled((Logger)this);
    }

    public List<Pod> org$apache$streampark$flink$kubernetes$helper$KubernetesDeploymentHelper$$getPods(String nameSpace, String deploymentName) {
        KubernetesClient x$1 = KubernetesRetriever$.MODULE$.newK8sClient();
        Serializable x$2 = new Serializable(nameSpace, deploymentName){
            public static final long serialVersionUID = 0L;
            public final String nameSpace$1;
            public final String deploymentName$1;

            public final List<Pod> apply(KubernetesClient client) {
                return (List)Try$.MODULE$.apply((Function0)new Serializable(this, client){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;
                    private final KubernetesClient client$1;

                    public final List<Pod> apply() {
                        return JavaConversions$.MODULE$.asScalaBuffer(((PodList)((Listable)((Filterable)this.client$1.pods().inNamespace(this.$outer.nameSpace$1)).withLabels(((Deployment)((Gettable)((Nameable)this.client$1.apps().deployments().inNamespace(this.$outer.nameSpace$1)).withName(this.$outer.deploymentName$1)).get()).getSpec().getSelector().getMatchLabels())).list()).getItems()).toList();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.client$1 = client$1;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<Pod> apply() {
                        return List$.MODULE$.empty();
                    }
                });
            }
            {
                this.nameSpace$1 = nameSpace$1;
                this.deploymentName$1 = deploymentName$1;
            }
        };
        Utils$.MODULE$.using$default$3((AutoCloseable)x$1, (Function1)x$2);
        Object x$3 = null;
        return (List)Utils$.MODULE$.using((AutoCloseable)x$1, (Function1)x$2, null);
    }

    public boolean getDeploymentStatusChanges(String nameSpace, String deploymentName) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(nameSpace, deploymentName){
            public static final long serialVersionUID = 0L;
            private final String nameSpace$2;
            private final String deploymentName$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                List<Pod> pods = KubernetesDeploymentHelper$.MODULE$.org$apache$streampark$flink$kubernetes$helper$KubernetesDeploymentHelper$$getPods(this.nameSpace$2, this.deploymentName$2);
                PodStatus podStatus = ((Pod)pods.head()).getStatus();
                String string = podStatus.getPhase();
                boolean bl = "Unknown".equals(string) ? true : ("Failed".equals(string) ? true : ("Pending".equals(string) ? false : ((ContainerStatus)JavaConversions$.MODULE$.asScalaBuffer(podStatus.getContainerStatuses()).head()).getLastState().getTerminated() != null));
                return bl;
            }
            {
                this.nameSpace$2 = nameSpace$2;
                this.deploymentName$2 = deploymentName$2;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return true;
            }
        }));
    }

    public Integer getTheNumberOfTaskDeploymentRetries(String nameSpace, String deploymentName) {
        List<Pod> pods = this.org$apache$streampark$flink$kubernetes$helper$KubernetesDeploymentHelper$$getPods(nameSpace, deploymentName);
        return ((ContainerStatus)JavaConversions$.MODULE$.asScalaBuffer(((Pod)pods.head()).getStatus().getContainerStatuses()).head()).getRestartCount();
    }

    public boolean deleteTaskDeployment(String nameSpace, String deploymentName) {
        KubernetesClient x$4 = KubernetesRetriever$.MODULE$.newK8sClient();
        Serializable x$5 = new Serializable(nameSpace, deploymentName){
            public static final long serialVersionUID = 0L;
            public final String nameSpace$3;
            public final String deploymentName$3;

            public final boolean apply(KubernetesClient client) {
                return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, client){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.2 $outer;
                    private final KubernetesClient client$2;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        Boolean r = ((Deletable)((Nameable)this.client$2.apps().deployments().inNamespace(this.$outer.nameSpace$3)).withName(this.$outer.deploymentName$3)).delete();
                        return BoxesRunTime.unboxToBoolean((Object)r);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.client$2 = client$2;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                }));
            }
            {
                this.nameSpace$3 = nameSpace$3;
                this.deploymentName$3 = deploymentName$3;
            }
        };
        Utils$.MODULE$.using$default$3((AutoCloseable)x$4, (Function1)x$5);
        Object x$6 = null;
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.using((AutoCloseable)x$4, (Function1)x$5, null));
    }

    public boolean isTheK8sConnectionNormal() {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DefaultKubernetesClient apply() {
                return new DefaultKubernetesClient();
            }
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DefaultKubernetesClient client = (DefaultKubernetesClient)success.value();
            client.close();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public String watchDeploymentLog(String nameSpace, String jobName, String jobId) {
        KubernetesClient x$7 = KubernetesRetriever$.MODULE$.newK8sClient();
        Serializable x$8 = new Serializable(nameSpace, jobName, jobId){
            public static final long serialVersionUID = 0L;
            private final String nameSpace$4;
            private final String jobName$1;
            private final String jobId$1;

            /*
             * WARNING - void declaration
             */
            public final String apply(KubernetesClient client) {
                void var2_2;
                String path = KubernetesDeploymentHelper$.MODULE$.getJobLog(this.jobId$1);
                File file = new File(path);
                String log = ((Loggable)((Nameable)client.apps().deployments().inNamespace(this.nameSpace$4)).withName(this.jobName$1)).getLog();
                Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)log);
                return var2_2;
            }
            {
                this.nameSpace$4 = nameSpace$4;
                this.jobName$1 = jobName$1;
                this.jobId$1 = jobId$1;
            }
        };
        Utils$.MODULE$.using$default$3((AutoCloseable)x$7, (Function1)x$8);
        Object x$9 = null;
        return (String)Utils$.MODULE$.using((AutoCloseable)x$7, (Function1)x$8, null);
    }

    public String watchPodTerminatedLog(String nameSpace, String jobName, String jobId) {
        return (String)Utils$.MODULE$.using((AutoCloseable)KubernetesRetriever$.MODULE$.newK8sClient(), (Function1)new Serializable(nameSpace, jobName, jobId){
            public static final long serialVersionUID = 0L;
            public final String nameSpace$5;
            public final String jobName$2;
            public final String jobId$2;

            public final String apply(KubernetesClient client) {
                return (String)Try$.MODULE$.apply((Function0)new Serializable(this, client){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.watchPodTerminatedLog.1 $outer;
                    private final KubernetesClient client$3;

                    /*
                     * WARNING - void declaration
                     */
                    public final String apply() {
                        void var2_2;
                        String podName = ((Pod)KubernetesDeploymentHelper$.MODULE$.org$apache$streampark$flink$kubernetes$helper$KubernetesDeploymentHelper$$getPods(this.$outer.nameSpace$5, this.$outer.jobName$2).head()).getMetadata().getName();
                        String path = KubernetesDeploymentHelper$.MODULE$.getJobErrorLog(this.$outer.jobId$2);
                        File file = new File(path);
                        String log = ((Loggable)((Prettyable)((Terminateable)((Nameable)this.client$3.pods().inNamespace(this.$outer.nameSpace$5)).withName(podName)).terminated()).withPrettyOutput()).getLog();
                        Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)log);
                        return var2_2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.client$3 = client$3;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
            }
            {
                this.nameSpace$5 = nameSpace$5;
                this.jobName$2 = jobName$2;
                this.jobId$2 = jobId$2;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Throwable error) {
                throw error;
            }
        });
    }

    public boolean deleteTaskConfigMap(String nameSpace, String deploymentName) {
        KubernetesClient x$10 = KubernetesRetriever$.MODULE$.newK8sClient();
        Serializable x$11 = new Serializable(nameSpace, deploymentName){
            public static final long serialVersionUID = 0L;
            public final String nameSpace$6;
            public final String deploymentName$4;

            public final boolean apply(KubernetesClient client) {
                return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, client){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.5 $outer;
                    private final KubernetesClient client$4;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        Boolean r = ((Deletable)((Filterable)this.client$4.configMaps().inNamespace(this.$outer.nameSpace$6)).withLabel("app", this.$outer.deploymentName$4)).delete();
                        return BoxesRunTime.unboxToBoolean((Object)r);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.client$4 = client$4;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                }));
            }
            {
                this.nameSpace$6 = nameSpace$6;
                this.deploymentName$4 = deploymentName$4;
            }
        };
        Utils$.MODULE$.using$default$3((AutoCloseable)x$10, (Function1)x$11);
        Object x$12 = null;
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.using((AutoCloseable)x$10, (Function1)x$11, null));
    }

    public String getJobLog(String jobId) {
        String tmpPath = SystemPropertyUtils$.MODULE$.getTmpdir();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".log"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpPath, jobId}));
    }

    public String getJobErrorLog(String jobId) {
        String tmpPath = SystemPropertyUtils$.MODULE$.getTmpdir();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "_err.log"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpPath, jobId}));
    }

    private KubernetesDeploymentHelper$() {
        MODULE$ = this;
        Logger.class.$init$((Logger)this);
    }
}

