/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.traversals;

import java.util.HashSet;
import java.util.Set;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.dag.IterationNode;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.util.Visitor;

public class StaticDynamicPathIdentifier
implements Visitor<OptimizerNode> {
    private final Set<OptimizerNode> seenBefore = new HashSet<OptimizerNode>();
    private final int costWeight;

    public StaticDynamicPathIdentifier(int costWeight) {
        this.costWeight = costWeight;
    }

    public boolean preVisit(OptimizerNode visitable) {
        return this.seenBefore.add(visitable);
    }

    public void postVisit(OptimizerNode visitable) {
        visitable.identifyDynamicPath(this.costWeight);
        if (visitable.isOnDynamicPath() && visitable instanceof IterationNode) {
            throw new CompilerException("Nested iterations are currently not supported.");
        }
    }
}

