/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.curator.framework.state;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.shaded.org.apache.curator.RetryPolicy;
import org.apache.hadoop.shaded.org.apache.curator.RetrySleeper;

class CircuitBreaker {
    private final RetryPolicy retryPolicy;
    private final ScheduledExecutorService service;
    private boolean isOpen = false;
    private int retryCount = 0;
    private long startNanos = 0L;

    CircuitBreaker(RetryPolicy retryPolicy, ScheduledExecutorService service) {
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy cannot be null");
        this.service = Objects.requireNonNull(service, "service cannot be null");
    }

    boolean isOpen() {
        return this.isOpen;
    }

    int getRetryCount() {
        return this.retryCount;
    }

    boolean tryToOpen(Runnable completion) {
        if (this.isOpen) {
            return false;
        }
        this.isOpen = true;
        this.retryCount = 0;
        this.startNanos = System.nanoTime();
        if (this.tryToRetry(completion)) {
            return true;
        }
        this.close();
        return false;
    }

    boolean tryToRetry(Runnable completion) {
        if (!this.isOpen) {
            return false;
        }
        long[] sleepTimeNanos = new long[]{0L};
        RetrySleeper retrySleeper = (time, unit) -> {
            sleepTimeNanos[0] = unit.toNanos(time);
        };
        Duration elapsedTime = Duration.ofNanos(System.nanoTime() - this.startNanos);
        if (this.retryPolicy.allowRetry(this.retryCount, elapsedTime.toMillis(), retrySleeper)) {
            ++this.retryCount;
            this.service.schedule(completion, sleepTimeNanos[0], TimeUnit.NANOSECONDS);
            return true;
        }
        return false;
    }

    boolean close() {
        boolean wasOpen = this.isOpen;
        this.retryCount = 0;
        this.isOpen = false;
        this.startNanos = 0L;
        return wasOpen;
    }
}

