/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopConfMountDecorator
extends AbstractKubernetesStepDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopConfMountDecorator.class);
    private final AbstractKubernetesParameters kubernetesParameters;

    public HadoopConfMountDecorator(AbstractKubernetesParameters kubernetesParameters) {
        this.kubernetesParameters = (AbstractKubernetesParameters)Preconditions.checkNotNull((Object)kubernetesParameters);
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        Volume hadoopConfVolume;
        Optional<String> existingConfigMap = this.kubernetesParameters.getExistingHadoopConfigurationConfigMap();
        if (existingConfigMap.isPresent()) {
            hadoopConfVolume = ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName("hadoop-config-volume")).withNewConfigMap().withName(existingConfigMap.get())).endConfigMap()).build();
        } else {
            Optional<String> localHadoopConfigurationDirectory = this.kubernetesParameters.getLocalHadoopConfigurationDirectory();
            if (!localHadoopConfigurationDirectory.isPresent()) {
                return flinkPod;
            }
            List<File> hadoopConfigurationFileItems = this.getHadoopConfigurationFileItems(localHadoopConfigurationDirectory.get());
            if (hadoopConfigurationFileItems.isEmpty()) {
                LOG.warn("Found 0 files in directory {}, skip to mount the Hadoop Configuration ConfigMap.", (Object)localHadoopConfigurationDirectory.get());
                return flinkPod;
            }
            List<KeyToPath> keyToPaths = hadoopConfigurationFileItems.stream().map(file -> ((KeyToPathBuilder)((KeyToPathBuilder)new KeyToPathBuilder().withKey(file.getName())).withPath(file.getName())).build()).collect(Collectors.toList());
            hadoopConfVolume = ((VolumeBuilder)((VolumeFluent.ConfigMapNested)((VolumeFluent.ConfigMapNested)((VolumeBuilder)new VolumeBuilder().withName("hadoop-config-volume")).withNewConfigMap().withName(HadoopConfMountDecorator.getHadoopConfConfigMapName(this.kubernetesParameters.getClusterId()))).withItems(keyToPaths)).endConfigMap()).build();
        }
        Pod podWithHadoopConf = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(flinkPod.getPodWithoutMainContainer()).editOrNewSpec().addNewVolumeLike(hadoopConfVolume).endVolume()).endSpec()).build();
        Container containerWithHadoopConf = ((ContainerBuilder)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((ContainerBuilder)((ContainerFluent.VolumeMountsNested)((ContainerFluent.VolumeMountsNested)new ContainerBuilder(flinkPod.getMainContainer()).addNewVolumeMount().withName("hadoop-config-volume")).withMountPath("/opt/hadoop/conf")).endVolumeMount()).addNewEnv().withName("HADOOP_CONF_DIR")).withValue("/opt/hadoop/conf")).endEnv()).build();
        return new FlinkPod.Builder(flinkPod).withPod(podWithHadoopConf).withMainContainer(containerWithHadoopConf).build();
    }

    @Override
    public List<HasMetadata> buildAccompanyingKubernetesResources() throws IOException {
        if (this.kubernetesParameters.getExistingHadoopConfigurationConfigMap().isPresent()) {
            return Collections.emptyList();
        }
        Optional<String> localHadoopConfigurationDirectory = this.kubernetesParameters.getLocalHadoopConfigurationDirectory();
        if (!localHadoopConfigurationDirectory.isPresent()) {
            return Collections.emptyList();
        }
        List<File> hadoopConfigurationFileItems = this.getHadoopConfigurationFileItems(localHadoopConfigurationDirectory.get());
        if (hadoopConfigurationFileItems.isEmpty()) {
            LOG.warn("Found 0 files in directory {}, skip to create the Hadoop Configuration ConfigMap.", (Object)localHadoopConfigurationDirectory.get());
            return Collections.emptyList();
        }
        HashMap<String, String> data = new HashMap<String, String>();
        for (File file : hadoopConfigurationFileItems) {
            data.put(file.getName(), FileUtils.readFileUtf8((File)file));
        }
        ConfigMap hadoopConfigMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapBuilder)new ConfigMapBuilder().withApiVersion("v1")).withNewMetadata().withName(HadoopConfMountDecorator.getHadoopConfConfigMapName(this.kubernetesParameters.getClusterId()))).withLabels(this.kubernetesParameters.getCommonLabels())).endMetadata()).addToData(data)).build();
        return Collections.singletonList(hadoopConfigMap);
    }

    private List<File> getHadoopConfigurationFileItems(String localHadoopConfigurationDirectory) {
        ArrayList<String> expectedFileNames = new ArrayList<String>();
        expectedFileNames.add("core-site.xml");
        expectedFileNames.add("hdfs-site.xml");
        File directory = new File(localHadoopConfigurationDirectory);
        if (directory.exists() && directory.isDirectory()) {
            return Arrays.stream(directory.listFiles()).filter(file -> file.isFile() && expectedFileNames.stream().anyMatch(name -> file.getName().equals(name))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static String getHadoopConfConfigMapName(String clusterId) {
        return "hadoop-config-" + clusterId;
    }
}

