/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.github.dockerjava.api.model.DockerObject;
import com.github.dockerjava.api.model.DockerObjectAccessor;
import java.io.IOException;
import java.util.HashMap;

class DockerObjectDeserializer
extends DelegatingDeserializer {
    private final BeanDescription beanDescription;
    private final ObjectMapper originalMapper;

    DockerObjectDeserializer(JsonDeserializer<?> delegate, BeanDescription beanDescription, ObjectMapper originalMapper) {
        super(delegate);
        this.beanDescription = beanDescription;
        this.originalMapper = originalMapper;
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return new DockerObjectDeserializer(newDelegatee, this.beanDescription, this.originalMapper);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode jsonNode = (JsonNode)p.readValueAsTree();
        Object deserializedObject = this.originalMapper.treeToValue((TreeNode)jsonNode, this.beanDescription.getBeanClass());
        if (deserializedObject instanceof DockerObject) {
            DockerObjectAccessor.overrideRawValues((DockerObject)((DockerObject)deserializedObject), (HashMap)((HashMap)this.originalMapper.convertValue((Object)jsonNode, HashMap.class)));
        }
        return deserializedObject;
    }
}

