/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.core.Ordered;
import springfox.documentation.service.VendorExtension;

public class Tag
implements Ordered {
    private final String name;
    private final String description;
    private final int order;
    private final List<VendorExtension> vendorExtensions;

    public Tag(String name, String description) {
        this(name, description, Integer.MAX_VALUE);
    }

    public Tag(String name, String description, int order) {
        this(name, description, order, new ArrayList<VendorExtension>());
    }

    public Tag(String name, String description, List<VendorExtension> vendorExtensions) {
        this(name, description, Integer.MAX_VALUE, vendorExtensions);
    }

    public Tag(String name, String description, int order, List<VendorExtension> vendorExtensions) {
        this.name = Objects.requireNonNull(name);
        this.description = description;
        this.order = order;
        this.vendorExtensions = new ArrayList<VendorExtension>(vendorExtensions);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOrder() {
        return this.order;
    }

    public List<VendorExtension> getVendorExtensions() {
        return this.vendorExtensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        return Objects.equals(this.name, tag.name) && Objects.equals(this.description, tag.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description);
    }
}

