/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceBudgetManager;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.runtime.taskexecutor.slot.SlotActions;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotActiveException;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotFoundException;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlot;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotPayload;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotState;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TimerService;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSlotTableImpl<T extends TaskSlotPayload>
implements TaskSlotTable<T> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskSlotTableImpl.class);
    private final int numberSlots;
    private final ResourceProfile defaultSlotResourceProfile;
    private final int memoryPageSize;
    private final TimerService<AllocationID> timerService;
    private final Map<Integer, TaskSlot<T>> taskSlots;
    private final Map<AllocationID, TaskSlot<T>> allocatedSlots;
    private final Map<ExecutionAttemptID, TaskSlotMapping<T>> taskSlotMappings;
    private final Map<JobID, Set<AllocationID>> slotsPerJob;
    @Nullable
    private SlotActions slotActions;
    private volatile State state;
    private int dynamicSlotIndex;
    private final ResourceBudgetManager budgetManager;
    private final CompletableFuture<Void> closingFuture;
    private ComponentMainThreadExecutor mainThreadExecutor = new ComponentMainThreadExecutor.DummyComponentMainThreadExecutor("TaskSlotTableImpl is not initialized with proper main thread executor, call to TaskSlotTableImpl#start is required");
    private final Executor memoryVerificationExecutor;

    public TaskSlotTableImpl(int numberSlots, ResourceProfile totalAvailableResourceProfile, ResourceProfile defaultSlotResourceProfile, int memoryPageSize, TimerService<AllocationID> timerService, Executor memoryVerificationExecutor) {
        Preconditions.checkArgument((0 < numberSlots ? 1 : 0) != 0, (Object)"The number of task slots must be greater than 0.");
        this.numberSlots = numberSlots;
        this.dynamicSlotIndex = numberSlots;
        this.defaultSlotResourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)defaultSlotResourceProfile);
        this.memoryPageSize = memoryPageSize;
        this.taskSlots = new HashMap<Integer, TaskSlot<T>>(numberSlots);
        this.timerService = (TimerService)Preconditions.checkNotNull(timerService);
        this.budgetManager = new ResourceBudgetManager((ResourceProfile)Preconditions.checkNotNull((Object)totalAvailableResourceProfile));
        this.allocatedSlots = new HashMap<AllocationID, TaskSlot<T>>(numberSlots);
        this.taskSlotMappings = new HashMap<ExecutionAttemptID, TaskSlotMapping<T>>(4 * numberSlots);
        this.slotsPerJob = new HashMap<JobID, Set<AllocationID>>(4);
        this.slotActions = null;
        this.state = State.CREATED;
        this.closingFuture = new CompletableFuture();
        this.memoryVerificationExecutor = memoryVerificationExecutor;
    }

    @Override
    public void start(SlotActions initialSlotActions, ComponentMainThreadExecutor mainThreadExecutor) {
        Preconditions.checkState((this.state == State.CREATED ? 1 : 0) != 0, (String)"The %s has to be just created before starting", (Object[])new Object[]{TaskSlotTableImpl.class.getSimpleName()});
        this.slotActions = (SlotActions)Preconditions.checkNotNull((Object)initialSlotActions);
        this.mainThreadExecutor = (ComponentMainThreadExecutor)Preconditions.checkNotNull((Object)mainThreadExecutor);
        this.timerService.start(this);
        this.state = State.RUNNING;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.state == State.CREATED) {
            this.state = State.CLOSED;
            this.closingFuture.complete(null);
        } else if (this.state == State.RUNNING) {
            this.state = State.CLOSING;
            FlinkException cause = new FlinkException("Closing task slot table");
            CompletableFuture cleanupFuture = FutureUtils.waitForAll((Collection)new ArrayList<TaskSlot<T>>(this.allocatedSlots.values()).stream().map(slot -> this.freeSlotInternal((TaskSlot<T>)slot, cause)).collect(Collectors.toList())).thenRunAsync(() -> {
                this.state = State.CLOSED;
                this.timerService.stop();
            }, (Executor)this.mainThreadExecutor);
            FutureUtils.forward((CompletableFuture)cleanupFuture, this.closingFuture);
        }
        return this.closingFuture;
    }

    @VisibleForTesting
    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    @Override
    public Set<AllocationID> getAllocationIdsPerJob(JobID jobId) {
        Set<AllocationID> allocationIds = this.slotsPerJob.get(jobId);
        if (allocationIds == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(allocationIds);
    }

    @Override
    public Set<AllocationID> getActiveTaskSlotAllocationIds() {
        return this.createAllocationIdSet(new TaskSlotIterator(TaskSlotState.ACTIVE));
    }

    @Override
    public Set<AllocationID> getActiveTaskSlotAllocationIdsPerJob(JobID jobId) {
        return this.createAllocationIdSet(new TaskSlotIterator(jobId, TaskSlotState.ACTIVE));
    }

    private Set<AllocationID> createAllocationIdSet(Iterator<TaskSlot<T>> taskSlotIterator) {
        HashSet<AllocationID> allocationIds = new HashSet<AllocationID>();
        while (taskSlotIterator.hasNext()) {
            allocationIds.add(taskSlotIterator.next().getAllocationId());
        }
        return allocationIds;
    }

    @Override
    public SlotReport createSlotReport(ResourceID resourceId) {
        SlotStatus slotStatus;
        ArrayList<SlotStatus> slotStatuses = new ArrayList<SlotStatus>();
        for (int i = 0; i < this.numberSlots; ++i) {
            SlotID slotId = new SlotID(resourceId, i);
            if (this.taskSlots.containsKey(i)) {
                TaskSlot<T> taskSlot = this.taskSlots.get(i);
                slotStatus = new SlotStatus(slotId, taskSlot.getResourceProfile(), taskSlot.getJobId(), taskSlot.getAllocationId());
            } else {
                slotStatus = new SlotStatus(slotId, this.defaultSlotResourceProfile, null, null);
            }
            slotStatuses.add(slotStatus);
        }
        for (TaskSlot<T> taskSlot : this.allocatedSlots.values()) {
            if (!this.isDynamicIndex(taskSlot.getIndex())) continue;
            slotStatus = new SlotStatus(new SlotID(resourceId, taskSlot.getIndex()), taskSlot.getResourceProfile(), taskSlot.getJobId(), taskSlot.getAllocationId());
            slotStatuses.add(slotStatus);
        }
        SlotReport slotReport = new SlotReport(slotStatuses);
        return slotReport;
    }

    @Override
    @VisibleForTesting
    public boolean allocateSlot(int index, JobID jobId, AllocationID allocationId, Time slotTimeout) {
        return this.allocateSlot(index, jobId, allocationId, this.defaultSlotResourceProfile, slotTimeout);
    }

    @Override
    public boolean allocateSlot(int requestedIndex, JobID jobId, AllocationID allocationId, ResourceProfile resourceProfile, Time slotTimeout) {
        this.checkRunning();
        Preconditions.checkArgument((requestedIndex < this.numberSlots ? 1 : 0) != 0);
        int index = requestedIndex < 0 ? this.nextDynamicSlotIndex() : requestedIndex;
        ResourceProfile effectiveResourceProfile = resourceProfile.equals(ResourceProfile.UNKNOWN) ? this.defaultSlotResourceProfile : resourceProfile;
        TaskSlot<T> taskSlot = this.allocatedSlots.get((Object)allocationId);
        if (taskSlot != null) {
            return this.isDuplicatedSlot(taskSlot, jobId, effectiveResourceProfile, index);
        }
        if (this.isIndexAlreadyTaken(index)) {
            LOG.info("The slot with index {} is already assigned to another allocation with id {}.", (Object)index, (Object)this.taskSlots.get(index).getAllocationId());
            return false;
        }
        if (!this.budgetManager.reserve(effectiveResourceProfile)) {
            LOG.info("Cannot allocate the requested resources. Trying to allocate {}, while the currently remaining available resources are {}, total is {}.", new Object[]{effectiveResourceProfile, this.budgetManager.getAvailableBudget(), this.budgetManager.getTotalBudget()});
            return false;
        }
        taskSlot = new TaskSlot(index, effectiveResourceProfile, this.memoryPageSize, jobId, allocationId, this.memoryVerificationExecutor);
        this.taskSlots.put(index, taskSlot);
        this.allocatedSlots.put(allocationId, taskSlot);
        this.timerService.registerTimeout(allocationId, slotTimeout.getSize(), slotTimeout.getUnit());
        Set<AllocationID> slots = this.slotsPerJob.get(jobId);
        if (slots == null) {
            slots = new HashSet<AllocationID>(4);
            this.slotsPerJob.put(jobId, slots);
        }
        slots.add(allocationId);
        return true;
    }

    private boolean isDuplicatedSlot(TaskSlot taskSlot, JobID jobId, ResourceProfile resourceProfile, int index) {
        LOG.info("Slot with allocationId {} already exist, with resource profile {}, job id {} and index {}. The required index is {}.", new Object[]{taskSlot.getAllocationId(), taskSlot.getResourceProfile(), taskSlot.getJobId(), taskSlot.getIndex(), index});
        return taskSlot.getJobId().equals((Object)jobId) && taskSlot.getResourceProfile().equals(resourceProfile) && (this.isDynamicIndex(index) || taskSlot.getIndex() == index);
    }

    private boolean isIndexAlreadyTaken(int index) {
        return this.taskSlots.get(index) != null;
    }

    private boolean isDynamicIndex(int index) {
        return index >= this.numberSlots;
    }

    @Override
    public boolean markSlotActive(AllocationID allocationId) throws SlotNotFoundException {
        this.checkRunning();
        TaskSlot<T> taskSlot = this.getTaskSlot(allocationId);
        if (taskSlot != null) {
            return this.markExistingSlotActive(taskSlot);
        }
        throw new SlotNotFoundException(allocationId);
    }

    private boolean markExistingSlotActive(TaskSlot<T> taskSlot) {
        if (taskSlot.markActive()) {
            LOG.info("Activate slot {}.", (Object)taskSlot.getAllocationId());
            this.timerService.unregisterTimeout(taskSlot.getAllocationId());
            return true;
        }
        return false;
    }

    @Override
    public boolean markSlotInactive(AllocationID allocationId, Time slotTimeout) throws SlotNotFoundException {
        this.checkStarted();
        TaskSlot<T> taskSlot = this.getTaskSlot(allocationId);
        if (taskSlot != null) {
            if (taskSlot.markInactive()) {
                this.timerService.registerTimeout(allocationId, slotTimeout.getSize(), slotTimeout.getUnit());
                return true;
            }
            return false;
        }
        throw new SlotNotFoundException(allocationId);
    }

    @Override
    public int freeSlot(AllocationID allocationId, Throwable cause) throws SlotNotFoundException {
        this.checkStarted();
        TaskSlot<T> taskSlot = this.getTaskSlot(allocationId);
        if (taskSlot != null) {
            return this.freeSlotInternal(taskSlot, cause).isDone() ? taskSlot.getIndex() : -1;
        }
        throw new SlotNotFoundException(allocationId);
    }

    private CompletableFuture<Void> freeSlotInternal(TaskSlot<T> taskSlot, Throwable cause) {
        AllocationID allocationId = taskSlot.getAllocationId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Free slot {}.", taskSlot, (Object)cause);
        } else {
            LOG.info("Free slot {}.", taskSlot);
        }
        if (taskSlot.isEmpty()) {
            this.allocatedSlots.remove((Object)allocationId);
            this.timerService.unregisterTimeout(allocationId);
            JobID jobId = taskSlot.getJobId();
            Set<AllocationID> slots = this.slotsPerJob.get(jobId);
            if (slots == null) {
                throw new IllegalStateException("There are no more slots allocated for the job " + jobId + ". This indicates a programming bug.");
            }
            slots.remove((Object)allocationId);
            if (slots.isEmpty()) {
                this.slotsPerJob.remove(jobId);
            }
            this.taskSlots.remove(taskSlot.getIndex());
            this.budgetManager.release(taskSlot.getResourceProfile());
        }
        return taskSlot.closeAsync(cause);
    }

    @Override
    public boolean isValidTimeout(AllocationID allocationId, UUID ticket) {
        this.checkStarted();
        return this.state == State.RUNNING && this.timerService.isValid(allocationId, ticket);
    }

    @Override
    public boolean isAllocated(int index, JobID jobId, AllocationID allocationId) {
        TaskSlot<T> taskSlot = this.taskSlots.get(index);
        if (taskSlot != null) {
            return taskSlot.isAllocated(jobId, allocationId);
        }
        return false;
    }

    @Override
    public boolean tryMarkSlotActive(JobID jobId, AllocationID allocationId) {
        TaskSlot<T> taskSlot = this.getTaskSlot(allocationId);
        if (taskSlot != null && taskSlot.isAllocated(jobId, allocationId)) {
            return this.markExistingSlotActive(taskSlot);
        }
        return false;
    }

    @Override
    public boolean isSlotFree(int index) {
        return !this.taskSlots.containsKey(index);
    }

    @Override
    public boolean hasAllocatedSlots(JobID jobId) {
        return this.getAllocatedSlots(jobId).hasNext();
    }

    @Override
    public Iterator<TaskSlot<T>> getAllocatedSlots(JobID jobId) {
        return new TaskSlotIterator(jobId, TaskSlotState.ALLOCATED);
    }

    @Override
    @Nullable
    public JobID getOwningJob(AllocationID allocationId) {
        TaskSlot<T> taskSlot = this.getTaskSlot(allocationId);
        if (taskSlot != null) {
            return taskSlot.getJobId();
        }
        return null;
    }

    @Override
    public boolean addTask(T task) throws SlotNotFoundException, SlotNotActiveException {
        this.checkRunning();
        Preconditions.checkNotNull(task);
        TaskSlot<T> taskSlot = this.getTaskSlot(task.getAllocationId());
        if (taskSlot != null) {
            if (taskSlot.isActive(task.getJobID(), task.getAllocationId())) {
                if (taskSlot.add(task)) {
                    this.taskSlotMappings.put(task.getExecutionId(), new TaskSlotMapping((TaskSlotPayload)task, taskSlot, null));
                    return true;
                }
                return false;
            }
            throw new SlotNotActiveException(task.getJobID(), task.getAllocationId());
        }
        throw new SlotNotFoundException(task.getAllocationId());
    }

    @Override
    public T removeTask(ExecutionAttemptID executionAttemptID) {
        this.checkStarted();
        TaskSlotMapping<T> taskSlotMapping = this.taskSlotMappings.remove(executionAttemptID);
        if (taskSlotMapping != null) {
            T task = taskSlotMapping.getTask();
            TaskSlot<T> taskSlot = taskSlotMapping.getTaskSlot();
            taskSlot.remove(task.getExecutionId());
            if (taskSlot.isReleasing() && taskSlot.isEmpty()) {
                this.slotActions.freeSlot(taskSlot.getAllocationId());
            }
            return task;
        }
        return null;
    }

    @Override
    public T getTask(ExecutionAttemptID executionAttemptID) {
        TaskSlotMapping<T> taskSlotMapping = this.taskSlotMappings.get(executionAttemptID);
        if (taskSlotMapping != null) {
            return taskSlotMapping.getTask();
        }
        return null;
    }

    @Override
    public Iterator<T> getTasks(JobID jobId) {
        return new PayloadIterator(jobId);
    }

    @Override
    public AllocationID getCurrentAllocation(int index) {
        TaskSlot<T> taskSlot = this.taskSlots.get(index);
        if (taskSlot == null) {
            return null;
        }
        return taskSlot.getAllocationId();
    }

    @Override
    public MemoryManager getTaskMemoryManager(AllocationID allocationID) throws SlotNotFoundException {
        TaskSlot<T> taskSlot = this.getTaskSlot(allocationID);
        if (taskSlot != null) {
            return taskSlot.getMemoryManager();
        }
        throw new SlotNotFoundException(allocationID);
    }

    @Override
    public void notifyTimeout(AllocationID key, UUID ticket) {
        this.checkStarted();
        if (this.slotActions != null) {
            this.slotActions.timeoutSlot(key, ticket);
        }
    }

    @Nullable
    private TaskSlot<T> getTaskSlot(AllocationID allocationId) {
        Preconditions.checkNotNull((Object)((Object)allocationId));
        return this.allocatedSlots.get((Object)allocationId);
    }

    private int nextDynamicSlotIndex() {
        return this.dynamicSlotIndex++;
    }

    private void checkRunning() {
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"The %s has to be running.", (Object[])new Object[]{TaskSlotTableImpl.class.getSimpleName()});
    }

    private void checkStarted() {
        Preconditions.checkState((this.state != State.CREATED ? 1 : 0) != 0, (String)"The %s has to be started (not created).", (Object[])new Object[]{TaskSlotTableImpl.class.getSimpleName()});
    }

    private static enum State {
        CREATED,
        RUNNING,
        CLOSING,
        CLOSED;

    }

    private final class PayloadIterator
    implements Iterator<T> {
        private final Iterator<TaskSlot<T>> taskSlotIterator;
        private Iterator<T> currentTasks;

        private PayloadIterator(JobID jobId) {
            this.taskSlotIterator = new TaskSlotIterator(jobId, TaskSlotState.ACTIVE);
            this.currentTasks = null;
        }

        @Override
        public boolean hasNext() {
            while ((this.currentTasks == null || !this.currentTasks.hasNext()) && this.taskSlotIterator.hasNext()) {
                TaskSlot taskSlot = this.taskSlotIterator.next();
                this.currentTasks = taskSlot.getTasks();
            }
            return this.currentTasks != null && this.currentTasks.hasNext();
        }

        @Override
        public T next() {
            while (this.currentTasks == null || !this.currentTasks.hasNext()) {
                TaskSlot taskSlot;
                try {
                    taskSlot = this.taskSlotIterator.next();
                }
                catch (NoSuchElementException e) {
                    throw new NoSuchElementException("No more tasks.");
                }
                this.currentTasks = taskSlot.getTasks();
            }
            return (TaskSlotPayload)this.currentTasks.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove tasks via this iterator.");
        }
    }

    private final class TaskSlotIterator
    implements Iterator<TaskSlot<T>> {
        private final Iterator<AllocationID> allSlots;
        private final TaskSlotState state;
        private TaskSlot<T> currentSlot;

        private TaskSlotIterator(TaskSlotState state) {
            this(taskSlotTableImpl.slotsPerJob.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()).iterator(), state);
        }

        private TaskSlotIterator(JobID jobId, TaskSlotState state) {
            this(taskSlotTableImpl.slotsPerJob.get(jobId) == null ? Collections.emptyIterator() : ((Set)taskSlotTableImpl.slotsPerJob.get(jobId)).iterator(), state);
        }

        private TaskSlotIterator(Iterator<AllocationID> allocationIDIterator, TaskSlotState state) {
            this.allSlots = (Iterator)Preconditions.checkNotNull(allocationIDIterator);
            this.state = (TaskSlotState)((Object)Preconditions.checkNotNull((Object)((Object)state)));
            this.currentSlot = null;
        }

        @Override
        public boolean hasNext() {
            while (this.currentSlot == null && this.allSlots.hasNext()) {
                AllocationID tempSlot = this.allSlots.next();
                TaskSlot taskSlot = TaskSlotTableImpl.this.getTaskSlot(tempSlot);
                if (taskSlot == null || taskSlot.getState() != this.state) continue;
                this.currentSlot = taskSlot;
            }
            return this.currentSlot != null;
        }

        @Override
        public TaskSlot<T> next() {
            AllocationID tempSlot;
            TaskSlot taskSlot;
            if (this.currentSlot != null) {
                TaskSlot result = this.currentSlot;
                this.currentSlot = null;
                return result;
            }
            do {
                try {
                    tempSlot = this.allSlots.next();
                }
                catch (NoSuchElementException e) {
                    throw new NoSuchElementException("No more task slots.");
                }
            } while ((taskSlot = TaskSlotTableImpl.this.getTaskSlot(tempSlot)) == null || taskSlot.getState() != this.state);
            return taskSlot;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove task slots via this iterator.");
        }
    }

    private static final class TaskSlotMapping<T extends TaskSlotPayload> {
        private final T task;
        private final TaskSlot<T> taskSlot;

        private TaskSlotMapping(T task, TaskSlot<T> taskSlot) {
            this.task = (TaskSlotPayload)Preconditions.checkNotNull(task);
            this.taskSlot = (TaskSlot)Preconditions.checkNotNull(taskSlot);
        }

        public T getTask() {
            return this.task;
        }

        public TaskSlot<T> getTaskSlot() {
            return this.taskSlot;
        }

        /* synthetic */ TaskSlotMapping(TaskSlotPayload x0, TaskSlot x1, 1 x2) {
            this(x0, x1);
        }
    }
}

