/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.io.IOException;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.runtime.state.metrics.AbstractLatencyTrackState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.StateLatencyMetricBase;
import org.apache.flink.util.function.ThrowingRunnable;

class LatencyTrackingValueState<K, N, T>
extends AbstractLatencyTrackState<K, N, T, InternalValueState<K, N, T>, ValueStateLatencyMetrics>
implements InternalValueState<K, N, T> {
    public LatencyTrackingValueState(String stateName, InternalValueState<K, N, T> original, LatencyTrackingStateConfig latencyTrackingStateConfig) {
        super(original, new ValueStateLatencyMetrics(stateName, latencyTrackingStateConfig.getMetricGroup(), latencyTrackingStateConfig.getSampleInterval(), latencyTrackingStateConfig.getHistorySize()));
    }

    public T value() throws IOException {
        if (((ValueStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnGet()) {
            return this.trackLatencyWithIOException(() -> ((InternalValueState)this.original).value(), "valueStateGetLatency");
        }
        return (T)((InternalValueState)this.original).value();
    }

    public void update(T value) throws IOException {
        if (((ValueStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnUpdate()) {
            this.trackLatencyWithIOException((ThrowingRunnable<IOException>)((ThrowingRunnable)() -> ((InternalValueState)this.original).update(value)), "valueStateUpdateLatency");
        } else {
            ((InternalValueState)this.original).update(value);
        }
    }

    static class ValueStateLatencyMetrics
    extends StateLatencyMetricBase {
        private static final String VALUE_STATE_GET_LATENCY = "valueStateGetLatency";
        private static final String VALUE_STATE_UPDATE_LATENCY = "valueStateUpdateLatency";
        private int getCount = 0;
        private int updateCount = 0;

        private ValueStateLatencyMetrics(String stateName, MetricGroup metricGroup, int sampleInterval, int historySize) {
            super(stateName, metricGroup, sampleInterval, historySize);
        }

        int getGetCount() {
            return this.getCount;
        }

        int getUpdateCount() {
            return this.updateCount;
        }

        private boolean trackLatencyOnGet() {
            this.getCount = this.loopUpdateCounter(this.getCount);
            return this.getCount == 1;
        }

        private boolean trackLatencyOnUpdate() {
            this.updateCount = this.loopUpdateCounter(this.updateCount);
            return this.updateCount == 1;
        }
    }
}

