/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.NetworkClientHandler;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.exception.LocalTransportException;
import org.apache.flink.runtime.io.network.netty.exception.RemoteTransportException;
import org.apache.flink.runtime.io.network.netty.exception.TransportException;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFuture;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.GenericFutureListener;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreditBasedPartitionRequestClientHandler
extends ChannelInboundHandlerAdapter
implements NetworkClientHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CreditBasedPartitionRequestClientHandler.class);
    private final ConcurrentMap<InputChannelID, RemoteInputChannel> inputChannels = new ConcurrentHashMap<InputChannelID, RemoteInputChannel>();
    private final ArrayDeque<ClientOutboundMessage> clientOutboundMessages = new ArrayDeque();
    private final AtomicReference<Throwable> channelError = new AtomicReference();
    private final ChannelFutureListener writeListener = new WriteAndFlushNextMessageIfPossibleListener();
    private final ConcurrentMap<InputChannelID, InputChannelID> cancelled = new ConcurrentHashMap<InputChannelID, InputChannelID>();
    private volatile ChannelHandlerContext ctx;

    CreditBasedPartitionRequestClientHandler() {
    }

    @Override
    public void addInputChannel(RemoteInputChannel listener) throws IOException {
        this.checkError();
        this.inputChannels.putIfAbsent(listener.getInputChannelId(), listener);
    }

    @Override
    public void removeInputChannel(RemoteInputChannel listener) {
        this.inputChannels.remove((Object)listener.getInputChannelId());
    }

    @Override
    public RemoteInputChannel getInputChannel(InputChannelID inputChannelId) {
        return (RemoteInputChannel)this.inputChannels.get((Object)inputChannelId);
    }

    @Override
    public void cancelRequestFor(InputChannelID inputChannelId) {
        if (inputChannelId == null || this.ctx == null) {
            return;
        }
        if (this.cancelled.putIfAbsent(inputChannelId, inputChannelId) == null) {
            this.ctx.writeAndFlush((Object)new NettyMessage.CancelPartitionRequest(inputChannelId));
        }
    }

    @Override
    public void notifyCreditAvailable(RemoteInputChannel inputChannel) {
        this.ctx.executor().execute(() -> this.ctx.pipeline().fireUserEventTriggered((Object)new AddCreditMessage(inputChannel)));
    }

    @Override
    public void notifyNewBufferSize(RemoteInputChannel inputChannel, int bufferSize) {
        this.ctx.executor().execute(() -> this.ctx.pipeline().fireUserEventTriggered((Object)new NewBufferSizeMessage(inputChannel, bufferSize)));
    }

    @Override
    public void resumeConsumption(RemoteInputChannel inputChannel) {
        this.ctx.executor().execute(() -> this.ctx.pipeline().fireUserEventTriggered((Object)new ResumeConsumptionMessage(inputChannel)));
    }

    @Override
    public void acknowledgeAllRecordsProcessed(RemoteInputChannel inputChannel) {
        this.ctx.executor().execute(() -> this.ctx.pipeline().fireUserEventTriggered((Object)new AcknowledgeAllRecordsProcessedMessage(inputChannel)));
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.ctx == null) {
            this.ctx = ctx;
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.inputChannels.isEmpty()) {
            SocketAddress remoteAddr = ctx.channel().remoteAddress();
            this.notifyAllChannelsOfErrorAndClose(new RemoteTransportException("Connection unexpectedly closed by remote task manager '" + remoteAddr + "'. This might indicate that the remote task manager was lost.", remoteAddr));
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof TransportException) {
            this.notifyAllChannelsOfErrorAndClose(cause);
        } else {
            TransportException tex;
            SocketAddress remoteAddr = ctx.channel().remoteAddress();
            if (cause.getMessage() != null && cause.getMessage().contains("Connection reset by peer")) {
                tex = new RemoteTransportException("Lost connection to task manager '" + remoteAddr + "'. This indicates that the remote task manager was lost.", remoteAddr, cause);
            } else {
                SocketAddress localAddr = ctx.channel().localAddress();
                tex = new LocalTransportException(String.format("%s (connection to '%s')", cause.getMessage(), remoteAddr), localAddr, cause);
            }
            this.notifyAllChannelsOfErrorAndClose(tex);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            this.decodeMsg(msg);
        }
        catch (Throwable t) {
            this.notifyAllChannelsOfErrorAndClose(t);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ClientOutboundMessage) {
            boolean triggerWrite = this.clientOutboundMessages.isEmpty();
            this.clientOutboundMessages.add((ClientOutboundMessage)msg);
            if (triggerWrite) {
                this.writeAndFlushNextMessageIfPossible(ctx.channel());
            }
        } else {
            ctx.fireUserEventTriggered(msg);
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.writeAndFlushNextMessageIfPossible(ctx.channel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllChannelsOfErrorAndClose(Throwable cause) {
        if (this.channelError.compareAndSet(null, cause)) {
            try {
                for (RemoteInputChannel inputChannel : this.inputChannels.values()) {
                    inputChannel.onError(cause);
                }
            }
            catch (Throwable t) {
                LOG.warn("An Exception was thrown during error notification of a remote input channel.", t);
            }
            finally {
                this.inputChannels.clear();
                this.clientOutboundMessages.clear();
                if (this.ctx != null) {
                    this.ctx.close();
                }
            }
        }
    }

    @VisibleForTesting
    void checkError() throws IOException {
        Throwable t = this.channelError.get();
        if (t != null) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("There has been an error in the channel.", t);
        }
    }

    private void decodeMsg(Object msg) throws Throwable {
        Class<?> msgClazz = msg.getClass();
        if (msgClazz == NettyMessage.BufferResponse.class) {
            NettyMessage.BufferResponse bufferOrEvent = (NettyMessage.BufferResponse)msg;
            RemoteInputChannel inputChannel = (RemoteInputChannel)this.inputChannels.get((Object)bufferOrEvent.receiverId);
            if (inputChannel == null || inputChannel.isReleased()) {
                bufferOrEvent.releaseBuffer();
                this.cancelRequestFor(bufferOrEvent.receiverId);
                return;
            }
            try {
                this.decodeBufferOrEvent(inputChannel, bufferOrEvent);
            }
            catch (Throwable t) {
                inputChannel.onError(t);
            }
        } else if (msgClazz == NettyMessage.ErrorResponse.class) {
            NettyMessage.ErrorResponse error = (NettyMessage.ErrorResponse)msg;
            SocketAddress remoteAddr = this.ctx.channel().remoteAddress();
            if (error.isFatalError()) {
                this.notifyAllChannelsOfErrorAndClose(new RemoteTransportException("Fatal error at remote task manager '" + remoteAddr + "'.", remoteAddr, error.cause));
            } else {
                RemoteInputChannel inputChannel = (RemoteInputChannel)this.inputChannels.get((Object)error.receiverId);
                if (inputChannel != null) {
                    if (error.cause.getClass() == PartitionNotFoundException.class) {
                        inputChannel.onFailedPartitionRequest();
                    } else {
                        inputChannel.onError(new RemoteTransportException("Error at remote task manager '" + remoteAddr + "'.", remoteAddr, error.cause));
                    }
                }
            }
        } else if (msgClazz == NettyMessage.BacklogAnnouncement.class) {
            NettyMessage.BacklogAnnouncement announcement = (NettyMessage.BacklogAnnouncement)msg;
            RemoteInputChannel inputChannel = (RemoteInputChannel)this.inputChannels.get((Object)announcement.receiverId);
            if (inputChannel == null || inputChannel.isReleased()) {
                this.cancelRequestFor(announcement.receiverId);
                return;
            }
            try {
                inputChannel.onSenderBacklog(announcement.backlog);
            }
            catch (Throwable throwable) {
                inputChannel.onError(throwable);
            }
        } else {
            throw new IllegalStateException("Received unknown message from producer: " + msg.getClass());
        }
    }

    private void decodeBufferOrEvent(RemoteInputChannel inputChannel, NettyMessage.BufferResponse bufferOrEvent) throws Throwable {
        if (bufferOrEvent.isBuffer() && bufferOrEvent.bufferSize == 0) {
            inputChannel.onEmptyBuffer(bufferOrEvent.sequenceNumber, bufferOrEvent.backlog);
        } else if (bufferOrEvent.getBuffer() != null) {
            inputChannel.onBuffer(bufferOrEvent.getBuffer(), bufferOrEvent.sequenceNumber, bufferOrEvent.backlog);
        } else {
            throw new IllegalStateException("The read buffer is null in credit-based input channel.");
        }
    }

    private void writeAndFlushNextMessageIfPossible(Channel channel) {
        Object msg;
        ClientOutboundMessage outboundMessage;
        if (this.channelError.get() != null || !channel.isWritable()) {
            return;
        }
        do {
            if ((outboundMessage = this.clientOutboundMessages.poll()) != null) continue;
            return;
        } while (outboundMessage.inputChannel.isReleased() || (msg = outboundMessage.buildMessage()) == null);
        channel.writeAndFlush(msg).addListener((GenericFutureListener)this.writeListener);
    }

    private static class AcknowledgeAllRecordsProcessedMessage
    extends ClientOutboundMessage {
        AcknowledgeAllRecordsProcessedMessage(RemoteInputChannel inputChannel) {
            super((RemoteInputChannel)Preconditions.checkNotNull((Object)inputChannel));
        }

        @Override
        Object buildMessage() {
            return new NettyMessage.AckAllUserRecordsProcessed(this.inputChannel.getInputChannelId());
        }
    }

    private static class ResumeConsumptionMessage
    extends ClientOutboundMessage {
        ResumeConsumptionMessage(RemoteInputChannel inputChannel) {
            super((RemoteInputChannel)Preconditions.checkNotNull((Object)inputChannel));
        }

        @Override
        Object buildMessage() {
            return new NettyMessage.ResumeConsumption(this.inputChannel.getInputChannelId());
        }
    }

    private static class NewBufferSizeMessage
    extends ClientOutboundMessage {
        private final int bufferSize;

        NewBufferSizeMessage(RemoteInputChannel inputChannel, int bufferSize) {
            super((RemoteInputChannel)Preconditions.checkNotNull((Object)inputChannel));
            this.bufferSize = bufferSize;
        }

        @Override
        public Object buildMessage() {
            return new NettyMessage.NewBufferSize(this.bufferSize, this.inputChannel.getInputChannelId());
        }
    }

    private static class AddCreditMessage
    extends ClientOutboundMessage {
        AddCreditMessage(RemoteInputChannel inputChannel) {
            super((RemoteInputChannel)Preconditions.checkNotNull((Object)inputChannel));
        }

        @Override
        public Object buildMessage() {
            int credits = this.inputChannel.getAndResetUnannouncedCredit();
            return credits > 0 ? new NettyMessage.AddCredit(credits, this.inputChannel.getInputChannelId()) : null;
        }
    }

    private static abstract class ClientOutboundMessage {
        protected final RemoteInputChannel inputChannel;

        ClientOutboundMessage(RemoteInputChannel inputChannel) {
            this.inputChannel = inputChannel;
        }

        @Nullable
        abstract Object buildMessage();
    }

    private class WriteAndFlushNextMessageIfPossibleListener
    implements ChannelFutureListener {
        private WriteAndFlushNextMessageIfPossibleListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            try {
                if (future.isSuccess()) {
                    CreditBasedPartitionRequestClientHandler.this.writeAndFlushNextMessageIfPossible(future.channel());
                } else if (future.cause() != null) {
                    CreditBasedPartitionRequestClientHandler.this.notifyAllChannelsOfErrorAndClose(future.cause());
                } else {
                    CreditBasedPartitionRequestClientHandler.this.notifyAllChannelsOfErrorAndClose(new IllegalStateException("Sending cancelled by user."));
                }
            }
            catch (Throwable t) {
                CreditBasedPartitionRequestClientHandler.this.notifyAllChannelsOfErrorAndClose(t);
            }
        }
    }
}

