/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.resources;

import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesResource;

public class KubernetesPod
extends KubernetesResource<Pod> {
    public KubernetesPod(Pod pod) {
        super(pod);
    }

    public String getName() {
        return ((Pod)this.getInternalResource()).getMetadata().getName();
    }

    public boolean isTerminated() {
        if (((Pod)this.getInternalResource()).getStatus() != null) {
            return ((Pod)this.getInternalResource()).getStatus().getContainerStatuses().stream().anyMatch(e -> e.getState() != null && e.getState().getTerminated() != null);
        }
        return false;
    }

    public boolean isScheduled() {
        if (((Pod)this.getInternalResource()).getStatus() != null) {
            return ((Pod)this.getInternalResource()).getStatus().getConditions().stream().anyMatch(e -> Objects.equals(e.getType(), "PodScheduled") && Objects.equals(e.getStatus(), "True"));
        }
        return false;
    }

    public String getTerminatedDiagnostics() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pod terminated, container termination statuses: [");
        if (((Pod)this.getInternalResource()).getStatus() != null) {
            sb.append(((Pod)this.getInternalResource()).getStatus().getContainerStatuses().stream().filter(containerStatus -> containerStatus.getState() != null && containerStatus.getState().getTerminated() != null).map(containerStatus -> {
                ContainerStateTerminated containerStateTerminated = containerStatus.getState().getTerminated();
                return String.format("%s(exitCode=%d, reason=%s, message=%s)", containerStatus.getName(), containerStateTerminated.getExitCode(), containerStateTerminated.getReason(), containerStateTerminated.getMessage());
            }).collect(Collectors.joining(",")));
        }
        sb.append("]");
        return sb.toString();
    }
}

