/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.parameters;

import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptionsInternal;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesParameters;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.util.Preconditions;

public abstract class AbstractKubernetesParameters
implements KubernetesParameters {
    protected final Configuration flinkConfig;

    public AbstractKubernetesParameters(Configuration flinkConfig) {
        this.flinkConfig = (Configuration)Preconditions.checkNotNull((Object)flinkConfig);
    }

    public Configuration getFlinkConfiguration() {
        return this.flinkConfig;
    }

    @Override
    public String getConfigDirectory() {
        String configDir = this.flinkConfig.getOptional(DeploymentOptionsInternal.CONF_DIR).orElse(this.flinkConfig.getString(KubernetesConfigOptions.FLINK_CONF_DIR));
        Preconditions.checkNotNull((Object)configDir);
        return configDir;
    }

    @Override
    public String getClusterId() {
        String clusterId = this.flinkConfig.getString(KubernetesConfigOptions.CLUSTER_ID);
        if (StringUtils.isBlank((CharSequence)clusterId)) {
            throw new IllegalArgumentException(KubernetesConfigOptions.CLUSTER_ID.key() + " must not be blank.");
        }
        if (clusterId.length() > 45) {
            throw new IllegalArgumentException(KubernetesConfigOptions.CLUSTER_ID.key() + " must be no more than " + 45 + " characters.");
        }
        return clusterId;
    }

    @Override
    public String getNamespace() {
        String namespace = this.flinkConfig.getString(KubernetesConfigOptions.NAMESPACE);
        Preconditions.checkArgument((!namespace.trim().isEmpty() ? 1 : 0) != 0, (Object)("Invalid " + KubernetesConfigOptions.NAMESPACE + "."));
        return namespace;
    }

    @Override
    public String getImage() {
        String containerImage = this.flinkConfig.getString(KubernetesConfigOptions.CONTAINER_IMAGE);
        Preconditions.checkArgument((!containerImage.trim().isEmpty() ? 1 : 0) != 0, (Object)("Invalid " + KubernetesConfigOptions.CONTAINER_IMAGE + "."));
        return containerImage;
    }

    @Override
    public KubernetesConfigOptions.ImagePullPolicy getImagePullPolicy() {
        return (KubernetesConfigOptions.ImagePullPolicy)((Object)this.flinkConfig.get(KubernetesConfigOptions.CONTAINER_IMAGE_PULL_POLICY));
    }

    @Override
    public LocalObjectReference[] getImagePullSecrets() {
        List imagePullSecrets = (List)this.flinkConfig.get(KubernetesConfigOptions.CONTAINER_IMAGE_PULL_SECRETS);
        if (imagePullSecrets == null) {
            return new LocalObjectReference[0];
        }
        return (LocalObjectReference[])imagePullSecrets.stream().map(String::trim).filter(secret -> !secret.isEmpty()).map(LocalObjectReference::new).toArray(LocalObjectReference[]::new);
    }

    @Override
    public Map<String, String> getCommonLabels() {
        return Collections.unmodifiableMap(KubernetesUtils.getCommonLabels(this.getClusterId()));
    }

    @Override
    public String getFlinkConfDirInPod() {
        return this.flinkConfig.getString(KubernetesConfigOptions.FLINK_CONF_DIR);
    }

    @Override
    public String getFlinkLogDirInPod() {
        return this.flinkConfig.getString(KubernetesConfigOptions.FLINK_LOG_DIR);
    }

    @Override
    public String getContainerEntrypoint() {
        return this.flinkConfig.getString(KubernetesConfigOptions.KUBERNETES_ENTRY_PATH);
    }

    @Override
    public boolean hasLogback() {
        String confDir = this.getConfigDirectory();
        File logbackFile = new File(confDir, "logback-console.xml");
        return logbackFile.exists();
    }

    @Override
    public boolean hasLog4j() {
        String confDir = this.getConfigDirectory();
        File log4jFile = new File(confDir, "log4j-console.properties");
        return log4jFile.exists();
    }

    @Override
    public Optional<String> getExistingHadoopConfigurationConfigMap() {
        String existingHadoopConfigMap = this.flinkConfig.getString(KubernetesConfigOptions.HADOOP_CONF_CONFIG_MAP);
        if (StringUtils.isBlank((CharSequence)existingHadoopConfigMap)) {
            return Optional.empty();
        }
        return Optional.of(existingHadoopConfigMap.trim());
    }

    @Override
    public Optional<String> getLocalHadoopConfigurationDirectory() {
        String hadoopConfDirEnv = System.getenv("HADOOP_CONF_DIR");
        if (StringUtils.isNotBlank((CharSequence)hadoopConfDirEnv)) {
            return Optional.of(hadoopConfDirEnv);
        }
        String hadoopHomeEnv = System.getenv("HADOOP_HOME");
        if (StringUtils.isNotBlank((CharSequence)hadoopHomeEnv)) {
            File hadoop2ConfDir = new File(hadoopHomeEnv, "/etc/hadoop");
            if (hadoop2ConfDir.exists()) {
                return Optional.of(hadoop2ConfDir.getAbsolutePath());
            }
            File hadoop1ConfDir = new File(hadoopHomeEnv, "/conf");
            if (hadoop1ConfDir.exists()) {
                return Optional.of(hadoop1ConfDir.getAbsolutePath());
            }
        }
        return Optional.empty();
    }

    @Override
    public Map<String, String> getSecretNamesToMountPaths() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.KUBERNETES_SECRETS).orElse(Collections.emptyMap());
    }

    @Override
    public List<Map<String, String>> getEnvironmentsFromSecrets() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.KUBERNETES_ENV_SECRET_KEY_REF).orElse(Collections.emptyList());
    }
}

