/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.time.Instant;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class InstantComparator
extends BasicTypeComparator<Instant> {
    private static final long serialVersionUID = 1L;
    private static final long SECONDS_MIN_VALUE = Instant.MIN.getEpochSecond();

    public InstantComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int rNanos;
        int lNanos;
        long rSeconds;
        long lSeconds = firstSource.readLong();
        int comp = lSeconds == (rSeconds = secondSource.readLong()) ? ((lNanos = firstSource.readInt()) < (rNanos = secondSource.readInt()) ? -1 : (lNanos == rNanos ? 0 : 1)) : (lSeconds < rSeconds ? -1 : 1);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 12;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    @Override
    public void putNormalizedKey(Instant record, MemorySegment target, int offset, int numBytes) {
        int secondsBytes = 8;
        long normalizedSeconds = record.getEpochSecond() - SECONDS_MIN_VALUE;
        if (numBytes >= 8) {
            target.putLongBigEndian(offset, normalizedSeconds);
            offset += 8;
            int nanosBytes = 4;
            if ((numBytes -= 8) >= 4) {
                target.putIntBigEndian(offset, record.getNano());
                offset += 4;
                numBytes -= 4;
                for (int i = 0; i < numBytes; ++i) {
                    target.put(offset + i, (byte)0);
                }
            } else {
                int nanos = record.getNano();
                for (int i = 0; i < numBytes; ++i) {
                    target.put(offset + i, (byte)(nanos >>> (3 - i << 3)));
                }
            }
        } else {
            for (int i = 0; i < numBytes; ++i) {
                target.put(offset + i, (byte)(normalizedSeconds >>> (7 - i << 3)));
            }
        }
    }

    @Override
    public TypeComparator<Instant> duplicate() {
        return new InstantComparator(this.ascendingComparison);
    }
}

