/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.watcher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.util.Timeout;
import org.apache.streampark.flink.kubernetes.ChangeEventBus;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatchController;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.apache.streampark.flink.kubernetes.MetricWatcherConfig;
import org.apache.streampark.flink.kubernetes.event.FlinkClusterMetricChangeEvent;
import org.apache.streampark.flink.kubernetes.model.ClusterKey;
import org.apache.streampark.flink.kubernetes.model.ClusterKey$;
import org.apache.streampark.flink.kubernetes.model.FlinkMetricCV;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import org.apache.streampark.flink.kubernetes.watcher.FlinkMetricWatcher$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkRestJmConfigItem$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkRestOverview;
import org.apache.streampark.flink.kubernetes.watcher.FlinkRestOverview$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkWatcher;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\r\u001b\u0001\u001dB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u007f\u0001\u0011)\u0019!C\u0002\u0001\"AA\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005F\u0001\t\u0015\r\u0011b\u0001G\u0011!Q\u0005A!A!\u0002\u00139\u0005\"B&\u0001\t\u0003a\u0005b\u0002*\u0001\u0005\u0004%Ia\u0015\u0005\u0007;\u0002\u0001\u000b\u0011\u0002+\t\u000fy\u0003!\u0019!C\u0006?\"1Q\r\u0001Q\u0001\n\u0001DqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004l\u0001\u0001\u0006I\u0001\u001b\u0005\nY\u0002\u0001\r\u00111A\u0005\n5D\u0011B \u0001A\u0002\u0003\u0007I\u0011B@\t\u0013Y\u0004\u0001\u0019!A!B\u0013q\u0007bBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\b\u0003/\u0001A\u0011IA\u000b\u0011\u001d\tI\u0002\u0001C!\u0003+Aq!a\u0007\u0001\t\u0003\n)\u0002C\u0004\u0002\u001e\u0001!\t!a\b\b\u0013\u0005E#$!A\t\u0002\u0005Mc\u0001C\r\u001b\u0003\u0003E\t!!\u0016\t\r-3B\u0011AA,\u0011%\tIFFI\u0001\n\u0003\tYF\u0001\nGY&t7.T3ue&\u001cw+\u0019;dQ\u0016\u0014(BA\u000e\u001d\u0003\u001d9\u0018\r^2iKJT!!\b\u0010\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002 A\u0005)a\r\\5oW*\u0011\u0011EI\u0001\u000bgR\u0014X-Y7qCJ\\'BA\u0012%\u0003\u0019\t\u0007/Y2iK*\tQ%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001Q92\u0004CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005!Q\u000f^5m\u0015\t\u0019\u0004%\u0001\u0004d_6lwN\\\u0005\u0003kA\u0012a\u0001T8hO\u0016\u0014\bCA\u001c9\u001b\u0005Q\u0012BA\u001d\u001b\u000511E.\u001b8l/\u0006$8\r[3s\u0003\u0011\u0019wN\u001c4\u0011\u0005qjT\"\u0001\u000f\n\u0005yb\"aE'fiJL7mV1uG\",'oQ8oM&<\u0017aD<bi\u000eD7i\u001c8ue>dG.\u001a:\u0016\u0003\u0005\u0003\"\u0001\u0010\"\n\u0005\rc\"a\u0006$mS:\\7\nO:XCR\u001c\u0007nQ8oiJ|G\u000e\\3s\u0003A9\u0018\r^2i\u0007>tGO]8mY\u0016\u0014\b%\u0001\u0005fm\u0016tGOQ;t+\u00059\u0005C\u0001\u001fI\u0013\tIED\u0001\bDQ\u0006tw-Z#wK:$()^:\u0002\u0013\u00154XM\u001c;CkN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002N#R\u0019aj\u0014)\u0011\u0005]\u0002\u0001\"B \u0007\u0001\b\t\u0005\"B#\u0007\u0001\b9\u0005b\u0002\u001e\u0007!\u0003\u0005\raO\u0001\u0012iJ\f7m\u001b+bg.,\u00050Z2Q_>dW#\u0001+\u0011\u0005U[V\"\u0001,\u000b\u0005]C\u0016AC2p]\u000e,(O]3oi*\u0011\u0011'\u0017\u0006\u00025\u0006!!.\u0019<b\u0013\tafKA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003I!(/Y2l)\u0006\u001c8.\u0012=fGB{w\u000e\u001c\u0011\u0002#Q\u0014\u0018mY6UCN\\W\t_3dkR|'/F\u0001a!\t\t7-D\u0001c\u0015\t9&&\u0003\u0002eE\nyR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002%Q\u0014\u0018mY6UCN\\W\t_3dkR|'\u000fI\u0001\ni&lWM]#yK\u000e,\u0012\u0001\u001b\t\u0003+&L!A\u001b,\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-\u0001\u0006uS6,'/\u0012=fG\u0002\nQ\u0002^5nKJ\u001c6\r[3ek2,W#\u000181\u0005=$\bcA+qe&\u0011\u0011O\u0016\u0002\u0010'\u000eDW\rZ;mK\u00124U\u000f^;sKB\u00111\u000f\u001e\u0007\u0001\t%)x\"!A\u0001\u0002\u000b\u0005qOA\u0002`IE\na\u0002^5nKJ\u001c6\r[3ek2,\u0007%\u0005\u0002ywB\u0011\u0011&_\u0005\u0003u*\u0012qAT8uQ&tw\r\u0005\u0002*y&\u0011QP\u000b\u0002\u0004\u0003:L\u0018!\u0005;j[\u0016\u00148k\u00195fIVdWm\u0018\u0013fcR!\u0011\u0011AA\u0004!\rI\u00131A\u0005\u0004\u0003\u000bQ#\u0001B+oSRD\u0011\"!\u0003\u000f\u0003\u0003\u0005\r!a\u0003\u0002\u0007a$\u0013\u0007\r\u0003\u0002\u000e\u0005E\u0001\u0003B+q\u0003\u001f\u00012a]A\t\t))\u0018qAA\u0001\u0002\u0003\u0015\ta^\u0001\bI>\u001cF/\u0019:u)\t\t\t!\u0001\u0004e_N#x\u000e]\u0001\bI>\u001cEn\\:f\u0003\u001d!wnV1uG\"\fabY8mY\u0016\u001cG/T3ue&\u001c7\u000f\u0006\u0003\u0002\"\u0005M\u0002#B\u0015\u0002$\u0005\u001d\u0012bAA\u0013U\t1q\n\u001d;j_:\u0004B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[a\u0012!B7pI\u0016d\u0017\u0002BA\u0019\u0003W\u0011QB\u00127j].lU\r\u001e:jG\u000e3\u0006bBA\u001b)\u0001\u0007\u0011qG\u0001\u0003S\u0012\u0004B!!\u000b\u0002:%!\u00111HA\u0016\u0005\u001d!&/Y2l\u0013\u0012D3\u0001AA !\u0011\t\t%!\u0014\u000e\u0005\u0005\r#bA,\u0002F)!\u0011qIA%\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0003\u0017\nQA[1wCbLA!a\u0014\u0002D\tQA\u000b\u001b:fC\u0012\u001c\u0016MZ3\u0002%\u0019c\u0017N\\6NKR\u0014\u0018nY,bi\u000eDWM\u001d\t\u0003oY\u0019\"A\u0006\u0015\u0015\u0005\u0005M\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002^)\u001a1(a\u0018,\u0005\u0005\u0005\u0004\u0003BA2\u0003Wj!!!\u001a\u000b\t\u0005\u001d\u0014\u0011N\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0012+\u0013\u0011\ti'!\u001a\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
@ThreadSafe
public class FlinkMetricWatcher
implements org.apache.streampark.common.util.Logger,
FlinkWatcher {
    private final MetricWatcherConfig conf;
    private final FlinkK8sWatchController watchController;
    private final ChangeEventBus eventBus;
    private final ExecutorService trackTaskExecPool;
    private final ExecutionContextExecutorService trackTaskExecutor;
    private final ScheduledExecutorService timerExec;
    private ScheduledFuture<?> timerSchedule;
    private final AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    private transient Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    public static MetricWatcherConfig $lessinit$greater$default$1() {
        return FlinkMetricWatcher$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public void start() {
        FlinkWatcher.start$(this);
    }

    @Override
    public void stop() {
        FlinkWatcher.stop$(this);
    }

    @Override
    public void close() {
        FlinkWatcher.close$(this);
    }

    @Override
    public void restart() {
        FlinkWatcher.restart$(this);
    }

    @Override
    public Runnable funcToRunnable(Function0<BoxedUnit> fun) {
        return FlinkWatcher.funcToRunnable$(this, fun);
    }

    public String logName() {
        return org.apache.streampark.common.util.Logger.logName$((org.apache.streampark.common.util.Logger)this);
    }

    public Logger logger() {
        return org.apache.streampark.common.util.Logger.logger$((org.apache.streampark.common.util.Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logInfo$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logInfo$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logDebug$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logDebug$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logTrace$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logTrace$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logWarn$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logWarn$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logError$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logError$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        org.apache.streampark.common.util.Logger.initializeLogIfNecessary$((org.apache.streampark.common.util.Logger)this, (boolean)isInterpreter);
    }

    @Override
    public AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started() {
        return this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    }

    @Override
    public final void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started_$eq(AtomicBoolean x$1) {
        this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started = x$1;
    }

    public Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public FlinkK8sWatchController watchController() {
        return this.watchController;
    }

    public ChangeEventBus eventBus() {
        return this.eventBus;
    }

    private ExecutorService trackTaskExecPool() {
        return this.trackTaskExecPool;
    }

    private ExecutionContextExecutorService trackTaskExecutor() {
        return this.trackTaskExecutor;
    }

    private ScheduledExecutorService timerExec() {
        return this.timerExec;
    }

    private ScheduledFuture<?> timerSchedule() {
        return this.timerSchedule;
    }

    private void timerSchedule_$eq(ScheduledFuture<?> x$1) {
        this.timerSchedule = x$1;
    }

    @Override
    public void doStart() {
        this.timerSchedule_$eq(this.timerExec().scheduleAtFixedRate(() -> this.doWatch(), 0L, this.conf.requestIntervalSec(), TimeUnit.SECONDS));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkMetricWatcher started.");
    }

    @Override
    public void doStop() {
        this.timerSchedule().cancel(true);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkMetricWatcher stopped.");
    }

    @Override
    public void doClose() {
        this.timerExec().shutdownNow();
        this.trackTaskExecutor().shutdownNow();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkMetricWatcher closed.");
    }

    @Override
    public void doWatch() {
        Object object = new Object();
        try {
            Set trackIds = (Set)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.watchController().getActiveWatchingIds()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            });
            Set futures = (Set)trackIds.map((Function1 & Serializable & scala.Serializable)id -> {
                void var2_2;
                Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.collectMetrics((TrackId)id), (ExecutionContext)this.trackTaskExecutor());
                future.onComplete((Function1 & Serializable & scala.Serializable)x$2 -> {
                    FlinkMetricWatcher.$anonfun$doWatch$6(this, id, x$2);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)this.trackTaskExecutor());
                return var2_2;
            }, Set$.MODULE$.canBuildFrom());
            Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, Set$.MODULE$.canBuildFrom(), (ExecutionContext)this.trackTaskExecutor()), (Duration)new package.DurationLong(package$.MODULE$.DurationLong($this.conf.requestTimeoutSec())).seconds())).failed().map((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("[FlinkMetricWatcher] tracking flink metrics on kubernetes mode timeout,").append(new StringBuilder(15).append(" limitSeconds=").append($this.conf.requestTimeoutSec()).append(",").toString()).append(new StringBuilder(21).append(" trackingClusterKeys=").append(trackIds$1.mkString(",")).toString()).toString());
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public Option<FlinkMetricCV> collectMetrics(TrackId id) {
        Option option;
        Object object = new Object();
        try {
            ClusterKey clusterKey = ClusterKey$.MODULE$.of(id);
            String flinkJmRestUrl = (String)this.watchController().getClusterRestUrl(clusterKey).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FlinkMetricWatcher.$anonfun$collectMetrics$1(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            FlinkRestOverview flinkOverview = (FlinkRestOverview)FlinkRestOverview$.MODULE$.as(Request.get((String)new StringBuilder(9).append(flinkJmRestUrl).append("/overview").toString()).connectTimeout(Timeout.ofSeconds((long)KubernetesRetriever$.MODULE$.FLINK_REST_AWAIT_TIMEOUT_SEC())).responseTimeout(Timeout.ofSeconds((long)KubernetesRetriever$.MODULE$.FLINK_CLIENT_TIMEOUT_SEC())).execute().returnContent().asString(StandardCharsets.UTF_8)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            Map flinkJmConfigs = (Map)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)FlinkRestJmConfigItem$.MODULE$.as(Request.get((String)new StringBuilder(18).append(flinkJmRestUrl).append("/jobmanager/config").toString()).connectTimeout(Timeout.ofSeconds((long)KubernetesRetriever$.MODULE$.FLINK_REST_AWAIT_TIMEOUT_SEC())).responseTimeout(Timeout.ofSeconds((long)KubernetesRetriever$.MODULE$.FLINK_CLIENT_TIMEOUT_SEC())).execute().returnContent().asString(StandardCharsets.UTF_8)).map((Function1 & Serializable & scala.Serializable)e -> new Tuple2((Object)e.key(), (Object)e.value()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
            });
            long ackTime = System.currentTimeMillis();
            String tmMemStr = (String)flinkJmConfigs.getOrElse((Object)TaskManagerOptions.TOTAL_PROCESS_MEMORY.key(), (Function0 & Serializable & scala.Serializable)() -> "0b");
            String jmMemStr = (String)flinkJmConfigs.getOrElse((Object)JobManagerOptions.TOTAL_PROCESS_MEMORY.key(), (Function0 & Serializable & scala.Serializable)() -> "0b");
            FlinkMetricCV flinkMetricCV = new FlinkMetricCV(Predef$.MODULE$.int2Integer(MemorySize.parse((String)jmMemStr).getMebiBytes()), Predef$.MODULE$.int2Integer(MemorySize.parse((String)tmMemStr).getMebiBytes() * Predef$.MODULE$.Integer2int(flinkOverview.taskManagers())), flinkOverview.taskManagers(), flinkOverview.slotsTotal(), flinkOverview.slotsAvailable(), flinkOverview.jobsRunning(), flinkOverview.jobsFinished(), flinkOverview.jobsCancelled(), flinkOverview.jobsFailed(), ackTime);
            option = new Some((Object)flinkMetricCV);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static final /* synthetic */ void $anonfun$doWatch$6(FlinkMetricWatcher $this, TrackId id$1, Try x$2) {
        Option option = (Option)x$2.getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            boolean isMetricChanged;
            Some some = (Some)option;
            FlinkMetricCV metric = (FlinkMetricCV)some.value();
            ClusterKey clusterKey = id$1.toClusterKey();
            $this.watchController().flinkMetrics().put(clusterKey, metric);
            FlinkMetricCV preMetric = $this.watchController().flinkMetrics().get(clusterKey);
            boolean bl = isMetricChanged = preMetric == null || !preMetric.equalsPayload(metric);
            if (isMetricChanged) {
                $this.eventBus().postAsync(new FlinkClusterMetricChangeEvent(id$1, metric));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$collectMetrics$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public FlinkMetricWatcher(MetricWatcherConfig conf, FlinkK8sWatchController watchController, ChangeEventBus eventBus) {
        this.conf = conf;
        this.watchController = watchController;
        this.eventBus = eventBus;
        org.apache.streampark.common.util.Logger.$init$((org.apache.streampark.common.util.Logger)this);
        FlinkWatcher.$init$(this);
        this.trackTaskExecPool = Executors.newWorkStealingPool();
        this.trackTaskExecutor = ExecutionContext$.MODULE$.fromExecutorService(this.trackTaskExecPool());
        this.timerExec = Executors.newSingleThreadScheduledExecutor();
    }
}

