/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.base.util.CommonUtils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.entity.SavePoint;
import org.apache.streampark.console.core.enums.CheckPointType;
import org.apache.streampark.console.core.mapper.SavePointMapper;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.apache.streampark.console.core.service.SavePointService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class SavePointServiceImpl
extends ServiceImpl<SavePointMapper, SavePoint>
implements SavePointService {
    private static final Logger log = LoggerFactory.getLogger(SavePointServiceImpl.class);
    @Autowired
    private FlinkEnvService flinkEnvService;

    @Override
    public void expire(Long appId) {
        SavePoint savePoint = new SavePoint();
        savePoint.setLatest(false);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SavePoint::getAppId, (Object)appId);
        this.update(savePoint, (Wrapper)queryWrapper);
    }

    public boolean save(SavePoint entity) {
        this.expire(entity);
        this.expire(entity.getAppId());
        return super.save((Object)entity);
    }

    private void expire(SavePoint entity) {
        FlinkEnv flinkEnv = this.flinkEnvService.getByAppId(entity.getAppId());
        Utils.required((flinkEnv != null ? 1 : 0) != 0);
        int cpThreshold = Integer.parseInt(flinkEnv.convertFlinkYamlAsMap().getOrDefault("state.checkpoints.num-retained", "5"));
        if (CheckPointType.CHECKPOINT.equals(CheckPointType.of(entity.getType()))) {
            --cpThreshold;
        }
        if (cpThreshold == 0) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SavePoint::getAppId, (Object)entity.getAppId())).eq(SavePoint::getType, (Object)1);
            this.remove((Wrapper)queryWrapper);
        } else {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SavePoint::getTriggerTime}).eq(SavePoint::getAppId, (Object)entity.getAppId())).eq(SavePoint::getType, (Object)CheckPointType.CHECKPOINT.get())).orderByDesc(SavePoint::getTriggerTime);
            Page savePointPage = (Page)((SavePointMapper)this.baseMapper).selectPage((IPage)new Page(1L, (long)(cpThreshold + 1)), (Wrapper)queryWrapper);
            if (!savePointPage.getRecords().isEmpty() && savePointPage.getRecords().size() > cpThreshold) {
                SavePoint savePoint = (SavePoint)savePointPage.getRecords().get(cpThreshold - 1);
                LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SavePoint::getAppId, (Object)entity.getAppId())).eq(SavePoint::getType, (Object)1)).lt(SavePoint::getTriggerTime, (Object)savePoint.getTriggerTime());
                this.remove((Wrapper)lambdaQueryWrapper);
            }
        }
    }

    @Override
    public SavePoint getLatest(Long id) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SavePoint::getAppId, (Object)id)).eq(SavePoint::getLatest, (Object)true);
        return (SavePoint)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean delete(Long id, Application application) throws InternalException {
        SavePoint savePoint = (SavePoint)this.getById(id);
        try {
            if (CommonUtils.notEmpty(savePoint.getPath()).booleanValue()) {
                application.getFsOperator().delete(savePoint.getPath());
            }
            this.removeById(id);
            return true;
        }
        catch (Exception e) {
            throw new InternalException(e.getMessage());
        }
    }

    @Override
    public IPage<SavePoint> page(SavePoint savePoint, RestRequest request) {
        Page page = new MybatisPager().getPage(request, "trigger_time", "desc");
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SavePoint::getAppId, (Object)savePoint.getAppId());
        return this.page((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public void removeApp(Application application) {
        Long appId = application.getId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SavePoint::getAppId, (Object)appId);
        this.remove((Wrapper)queryWrapper);
        try {
            application.getFsOperator().delete(application.getWorkspace().APP_SAVEPOINTS().concat("/").concat(appId.toString()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

