/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shiro.SecurityUtils;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.service.CommonService;
import org.apache.streampark.console.system.authentication.JWTUtil;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonServiceImpl
implements CommonService {
    private String sqlClientJar = null;
    @Autowired
    private UserService userService;

    @Override
    public User getCurrentUser() {
        String token = (String)SecurityUtils.getSubject().getPrincipal();
        Long userId = JWTUtil.getUserId(token);
        return (User)this.userService.getById(userId);
    }

    @Override
    public Long getUserId() {
        User user = this.getCurrentUser();
        if (user != null) {
            return user.getUserId();
        }
        return null;
    }

    @Override
    public String getSqlClientJar(FlinkEnv flinkEnv) {
        if (this.sqlClientJar == null) {
            File localClient = WebUtils.getAppClientDir();
            if (!localClient.exists()) {
                throw new ApiAlertException("[StreamPark] " + localClient + " no exists. please check.");
            }
            List jars = Arrays.stream((Object[])Objects.requireNonNull(localClient.list())).filter(x -> x.matches("streampark-flink-sqlclient_" + flinkEnv.getScalaVersion() + "-.*\\.jar")).collect(Collectors.toList());
            if (jars.isEmpty()) {
                throw new ApiAlertException("[StreamPark] can no found streampark-flink-sqlclient jar in " + localClient);
            }
            if (jars.size() > 1) {
                throw new ApiAlertException("[StreamPark] found multiple streampark-flink-sqlclient jar in " + localClient);
            }
            this.sqlClientJar = (String)jars.get(0);
        }
        return this.sqlClientJar;
    }
}

