/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.core.annotation.ApiAccess;
import org.apache.streampark.console.core.annotation.AppUpdated;
import org.apache.streampark.console.core.bean.AppControl;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ApplicationBackUp;
import org.apache.streampark.console.core.entity.ApplicationLog;
import org.apache.streampark.console.core.enums.AppExistsState;
import org.apache.streampark.console.core.service.AppBuildPipeService;
import org.apache.streampark.console.core.service.ApplicationBackUpService;
import org.apache.streampark.console.core.service.ApplicationLogService;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.flink.packer.pipeline.PipelineStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"FLINK_APPLICATION_TAG"})
@Validated
@RestController
@RequestMapping(value={"flink/app"})
public class ApplicationController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationController.class);
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationBackUpService backUpService;
    @Autowired
    private ApplicationLogService applicationLogService;
    @Autowired
    private AppBuildPipeService appBuildPipeService;

    @ApiAccess
    @PostMapping(value={"get"})
    @RequiresPermissions(value={"app:detail"})
    public RestResponse get(Application app) {
        Application application = this.applicationService.getApp(app);
        return RestResponse.success(application);
    }

    @ApiAccess
    @PostMapping(value={"create"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse create(Application app) throws IOException {
        boolean saved = this.applicationService.create(app);
        return RestResponse.success(saved);
    }

    @ApiAccess
    @ApiOperation(value="Copy application from the exist app", tags={"FLINK_APPLICATION_OPERATION_TAG"}, consumes="application/x-www-form-urlencoded")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="copy target app id", required=true, paramType="query", dataTypeClass=Long.class), @ApiImplicitParam(name="jobName", value="name of the copied application", required=true, paramType="query", dataTypeClass=String.class, defaultValue=""), @ApiImplicitParam(name="args", value="commit parameters after copying", required=false, paramType="query", dataTypeClass=String.class, defaultValue="")})
    @PostMapping(value={"copy"}, consumes={"application/x-www-form-urlencoded"})
    @RequiresPermissions(value={"app:copy"})
    public RestResponse copy(@ApiIgnore Application app) throws IOException {
        Long id = this.applicationService.copy(app);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", Long.toString(id));
        return id.equals(0L) ? RestResponse.success(false).data(data) : RestResponse.success(true).data(data);
    }

    @AppUpdated
    @PostMapping(value={"update"})
    @RequiresPermissions(value={"app:update"})
    public RestResponse update(Application app) {
        this.applicationService.update(app);
        return RestResponse.success(true);
    }

    @PostMapping(value={"dashboard"})
    public RestResponse dashboard(Long teamId) {
        Map<String, Serializable> map = this.applicationService.dashboard(teamId);
        return RestResponse.success(map);
    }

    @ApiAccess
    @PostMapping(value={"list"})
    @RequiresPermissions(value={"app:view"})
    public RestResponse list(Application app, RestRequest request) {
        IPage<Application> applicationList = this.applicationService.page(app, request);
        List appRecords = applicationList.getRecords();
        List<Long> appIds = appRecords.stream().map(Application::getId).collect(Collectors.toList());
        Map<Long, PipelineStatus> pipeStates = this.appBuildPipeService.listPipelineStatus(appIds);
        appRecords = appRecords.stream().peek(e -> {
            if (pipeStates.containsKey(e.getId())) {
                e.setBuildStatus(((PipelineStatus)pipeStates.get(e.getId())).getCode());
            }
        }).peek(e -> {
            AppControl appControl = new AppControl().setAllowBuild(e.getBuildStatus() == null || !PipelineStatus.running.getCode().equals(e.getBuildStatus())).setAllowStart(!e.shouldBeTrack() && PipelineStatus.success.getCode().equals(e.getBuildStatus())).setAllowStop(e.isRunning());
            e.setAppControl(appControl);
        }).collect(Collectors.toList());
        applicationList.setRecords(appRecords);
        return RestResponse.success(applicationList);
    }

    @AppUpdated
    @PostMapping(value={"mapping"})
    @RequiresPermissions(value={"app:mapping"})
    public RestResponse mapping(Application app) {
        boolean flag = this.applicationService.mapping(app);
        return RestResponse.success(flag);
    }

    @AppUpdated
    @PostMapping(value={"revoke"})
    @RequiresPermissions(value={"app:launch"})
    public RestResponse revoke(Application app) {
        this.applicationService.revoke(app);
        return RestResponse.success();
    }

    @ApiAccess
    @ApiOperation(value="Start application", tags={"FLINK_APPLICATION_OPERATION_TAG"}, consumes="application/x-www-form-urlencoded")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="app Id", required=true, paramType="query", dataTypeClass=Long.class), @ApiImplicitParam(name="savePointed", value="restored app from the savepoint or latest checkpoint", required=true, paramType="query", dataTypeClass=Boolean.class, defaultValue="false"), @ApiImplicitParam(name="savePoint", value="savepoint or checkpoint path", required=true, paramType="query", dataTypeClass=String.class, defaultValue=""), @ApiImplicitParam(name="allowNonRestored", value="ignore savepoint then cannot be restored", required=true, paramType="query", dataTypeClass=Boolean.class, defaultValue="false")})
    @PostMapping(value={"start"}, consumes={"application/x-www-form-urlencoded"})
    @RequiresPermissions(value={"app:start"})
    public RestResponse start(@ApiIgnore Application app) {
        try {
            this.applicationService.checkEnv(app);
            this.applicationService.starting(app);
            this.applicationService.start(app, false);
            return RestResponse.success(true);
        }
        catch (Exception e) {
            return RestResponse.success(false).message(e.getMessage());
        }
    }

    @ApiAccess
    @ApiOperation(value="Cancel application", tags={"FLINK_APPLICATION_OPERATION_TAG"}, consumes="application/x-www-form-urlencoded")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="app id", required=true, paramType="query", dataTypeClass=Long.class), @ApiImplicitParam(name="savePointed", value="whether trigger savepoint before taking stopping", required=true, paramType="query", dataTypeClass=Boolean.class, defaultValue="false"), @ApiImplicitParam(name="savePoint", value="savepoint path", paramType="query", dataTypeClass=String.class, defaultValue="hdfs:///tm/xxx"), @ApiImplicitParam(name="drain", value="send max watermark before canceling", required=true, paramType="query", dataTypeClass=Boolean.class, defaultValue="false")})
    @PostMapping(value={"cancel"}, consumes={"application/x-www-form-urlencoded"})
    @RequiresPermissions(value={"app:cancel"})
    public RestResponse cancel(@ApiIgnore Application app) throws Exception {
        this.applicationService.cancel(app);
        return RestResponse.success();
    }

    @AppUpdated
    @ApiAccess
    @PostMapping(value={"clean"})
    @RequiresPermissions(value={"app:clean"})
    public RestResponse clean(Application app) {
        this.applicationService.clean(app);
        return RestResponse.success(true);
    }

    @PostMapping(value={"forcedStop"})
    @RequiresPermissions(value={"app:cancel"})
    public RestResponse forcedStop(Application app) {
        this.applicationService.forcedStop(app);
        return RestResponse.success();
    }

    @PostMapping(value={"yarn"})
    public RestResponse yarn() {
        return RestResponse.success(YarnUtils.getRMWebAppProxyURL());
    }

    @PostMapping(value={"name"})
    public RestResponse yarnName(Application app) {
        String yarnName = this.applicationService.getYarnName(app);
        return RestResponse.success(yarnName);
    }

    @PostMapping(value={"checkName"})
    public RestResponse checkName(Application app) {
        AppExistsState exists = this.applicationService.checkExists(app);
        return RestResponse.success(exists.get());
    }

    @PostMapping(value={"readConf"})
    public RestResponse readConf(Application app) throws IOException {
        String config = this.applicationService.readConf(app);
        return RestResponse.success(config);
    }

    @PostMapping(value={"main"})
    public RestResponse getMain(Application application) {
        String mainClass = this.applicationService.getMain(application);
        return RestResponse.success(mainClass);
    }

    @PostMapping(value={"backups"})
    public RestResponse backups(ApplicationBackUp backUp, RestRequest request) {
        IPage<ApplicationBackUp> backups = this.backUpService.page(backUp, request);
        return RestResponse.success(backups);
    }

    @PostMapping(value={"rollback"})
    public RestResponse rollback(ApplicationBackUp backUp) {
        return RestResponse.success();
    }

    @PostMapping(value={"optionlog"})
    public RestResponse optionlog(ApplicationLog applicationLog, RestRequest request) {
        IPage<ApplicationLog> applicationList = this.applicationLogService.page(applicationLog, request);
        return RestResponse.success(applicationList);
    }

    @PostMapping(value={"delete"})
    public RestResponse delete(Application app) throws InternalException {
        Boolean deleted = this.applicationService.delete(app);
        return RestResponse.success(deleted);
    }

    @PostMapping(value={"deletebak"})
    public RestResponse deleteBak(ApplicationBackUp backUp) throws InternalException {
        Boolean deleted = this.backUpService.delete(backUp.getId());
        return RestResponse.success(deleted);
    }

    @PostMapping(value={"checkjar"})
    public RestResponse checkjar(String jar) {
        File file = new File(jar);
        try {
            Utils.checkJarFile((URL)file.toURI().toURL());
            return RestResponse.success(true);
        }
        catch (IOException e) {
            return RestResponse.success(file).message(e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"upload"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse upload(MultipartFile file) throws Exception {
        String uploadPath = this.applicationService.upload(file);
        return RestResponse.success(uploadPath);
    }

    @PostMapping(value={"downlog"})
    public RestResponse downlog(Long id) {
        this.applicationService.tailMvnDownloading(id);
        return RestResponse.success();
    }

    @PostMapping(value={"verifySchema"})
    public RestResponse verifySchema(String path) {
        URI uri = URI.create(path);
        String scheme = uri.getScheme();
        String pathPart = uri.getPath();
        RestResponse restResponse = RestResponse.success(true);
        String error = null;
        if (scheme == null) {
            error = "The scheme (hdfs://, file://, etc) is null. Please specify the file system scheme explicitly in the URI.";
        } else if (pathPart == null) {
            error = "The path to store the checkpoint data in is null. Please specify a directory path for the checkpoint data.";
        } else if (pathPart.length() == 0 || pathPart.equals("/")) {
            error = "Cannot use the root directory for checkpoints.";
        }
        if (error != null) {
            restResponse = RestResponse.success(false).message(error);
        }
        return restResponse;
    }

    @PostMapping(value={"checkSavepointPath"})
    public RestResponse checkSavepointPath(Application app) throws Exception {
        String error = this.applicationService.checkSavepointPath(app);
        if (error == null) {
            return RestResponse.success(true);
        }
        return RestResponse.success(false).message(error);
    }

    @ApiOperation(value="Read flink on k8s deploy log")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="app id"), @ApiImplicitParam(name="offset", value="number of log lines offset"), @ApiImplicitParam(name="limit", value="number of log lines loaded at once")})
    @PostMapping(value={"k8sStartLog"})
    public RestResponse k8sStartLog(Long id, Integer offset, Integer limit) throws Exception {
        String resp = this.applicationService.k8sStartLog(id, offset, limit);
        return RestResponse.success(resp);
    }
}

