/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.aspect;

import java.util.Objects;
import org.apache.shiro.SecurityUtils;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.core.annotation.ApiAccess;
import org.apache.streampark.console.core.task.FlinkRESTAPIWatcher;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class StreamParkAspect {
    private static final Logger log = LoggerFactory.getLogger(StreamParkAspect.class);
    @Autowired
    private FlinkRESTAPIWatcher flinkRESTAPIWatcher;

    @Pointcut(value="execution(public org.apache.streampark.console.base.domain.RestResponse org.apache.streampark.console.*.controller.*.*(..))")
    public void apiAccess() {
    }

    @Around(value="apiAccess()")
    public RestResponse apiAccess(ProceedingJoinPoint joinPoint) throws Throwable {
        ApiAccess apiAccess;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        log.debug("restResponse aspect, method:{}", (Object)methodSignature.getName());
        Boolean isApi = (Boolean)SecurityUtils.getSubject().getSession().getAttribute((Object)"is_api_token");
        if (Objects.nonNull(isApi) && isApi.booleanValue() && (Objects.isNull(apiAccess = methodSignature.getMethod().getAnnotation(ApiAccess.class)) || !apiAccess.value())) {
            throw new ApiAlertException("api accessToken authentication failed!");
        }
        return (RestResponse)joinPoint.proceed();
    }

    @Pointcut(value="@annotation(org.apache.streampark.console.core.annotation.AppUpdated)")
    public void appUpdated() {
    }

    @Around(value="appUpdated()")
    public Object appUpdated(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        log.debug("appUpdated aspect, method:{}", (Object)methodSignature.getName());
        Object target = joinPoint.proceed();
        this.flinkRESTAPIWatcher.init();
        return target;
    }
}

